package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  TagValue,
  TagKey,
  StoreDescription,
  CreateAnnotationStoreRequestNameString
}
import scala.jdk.CollectionConverters._
final case class CreateAnnotationStoreRequest(
    reference: Optional[zio.aws.omics.model.ReferenceItem] = Optional.Absent,
    name: Optional[CreateAnnotationStoreRequestNameString] = Optional.Absent,
    description: Optional[StoreDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    sseConfig: Optional[zio.aws.omics.model.SseConfig] = Optional.Absent,
    storeFormat: zio.aws.omics.model.StoreFormat,
    storeOptions: Optional[zio.aws.omics.model.StoreOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest = {
    import CreateAnnotationStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest
      .builder()
      .optionallyWith(reference.map(value => value.buildAwsValue()))(
        _.reference
      )
      .optionallyWith(
        name.map(value =>
          CreateAnnotationStoreRequestNameString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          StoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(sseConfig.map(value => value.buildAwsValue()))(
        _.sseConfig
      )
      .storeFormat(storeFormat.unwrap)
      .optionallyWith(storeOptions.map(value => value.buildAwsValue()))(
        _.storeOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateAnnotationStoreRequest.ReadOnly =
    zio.aws.omics.model.CreateAnnotationStoreRequest.wrap(buildAwsValue())
}
object CreateAnnotationStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateAnnotationStoreRequest =
      zio.aws.omics.model.CreateAnnotationStoreRequest(
        reference.map(value => value.asEditable),
        name.map(value => value),
        description.map(value => value),
        tags.map(value => value),
        sseConfig.map(value => value.asEditable),
        storeFormat,
        storeOptions.map(value => value.asEditable)
      )
    def reference: Optional[zio.aws.omics.model.ReferenceItem.ReadOnly]
    def name: Optional[CreateAnnotationStoreRequestNameString]
    def description: Optional[StoreDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly]
    def storeFormat: zio.aws.omics.model.StoreFormat
    def storeOptions: Optional[zio.aws.omics.model.StoreOptions.ReadOnly]
    def getReference
        : ZIO[Any, AwsError, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      AwsError.unwrapOptionField("reference", reference)
    def getName: ZIO[Any, AwsError, CreateAnnotationStoreRequestNameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, StoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSseConfig
        : ZIO[Any, AwsError, zio.aws.omics.model.SseConfig.ReadOnly] =
      AwsError.unwrapOptionField("sseConfig", sseConfig)
    def getStoreFormat: ZIO[Any, Nothing, zio.aws.omics.model.StoreFormat] =
      ZIO.succeed(storeFormat)
    def getStoreOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.StoreOptions.ReadOnly] =
      AwsError.unwrapOptionField("storeOptions", storeOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest
  ) extends zio.aws.omics.model.CreateAnnotationStoreRequest.ReadOnly {
    override val reference
        : Optional[zio.aws.omics.model.ReferenceItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reference())
        .map(value => zio.aws.omics.model.ReferenceItem.wrap(value))
    override val name: Optional[CreateAnnotationStoreRequestNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateAnnotationStoreRequestNameString(value)
        )
    override val description: Optional[StoreDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.omics.model.primitives.StoreDescription(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseConfig())
        .map(value => zio.aws.omics.model.SseConfig.wrap(value))
    override val storeFormat: zio.aws.omics.model.StoreFormat =
      zio.aws.omics.model.StoreFormat.wrap(impl.storeFormat())
    override val storeOptions
        : Optional[zio.aws.omics.model.StoreOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storeOptions())
        .map(value => zio.aws.omics.model.StoreOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest
  ): zio.aws.omics.model.CreateAnnotationStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
