package zio.aws.omics.model
import zio.aws.omics.model.primitives.{CreationTime, ResourceId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateAnnotationStoreResponse(
    id: ResourceId,
    reference: Optional[zio.aws.omics.model.ReferenceItem] = Optional.Absent,
    storeFormat: Optional[zio.aws.omics.model.StoreFormat] = Optional.Absent,
    storeOptions: Optional[zio.aws.omics.model.StoreOptions] = Optional.Absent,
    status: zio.aws.omics.model.StoreStatus,
    name: String,
    creationTime: CreationTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse = {
    import CreateAnnotationStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .optionallyWith(reference.map(value => value.buildAwsValue()))(
        _.reference
      )
      .optionallyWith(storeFormat.map(value => value.unwrap))(_.storeFormat)
      .optionallyWith(storeOptions.map(value => value.buildAwsValue()))(
        _.storeOptions
      )
      .status(status.unwrap)
      .name(name: java.lang.String)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateAnnotationStoreResponse.ReadOnly =
    zio.aws.omics.model.CreateAnnotationStoreResponse.wrap(buildAwsValue())
}
object CreateAnnotationStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateAnnotationStoreResponse =
      zio.aws.omics.model.CreateAnnotationStoreResponse(
        id,
        reference.map(value => value.asEditable),
        storeFormat.map(value => value),
        storeOptions.map(value => value.asEditable),
        status,
        name,
        creationTime
      )
    def id: ResourceId
    def reference: Optional[zio.aws.omics.model.ReferenceItem.ReadOnly]
    def storeFormat: Optional[zio.aws.omics.model.StoreFormat]
    def storeOptions: Optional[zio.aws.omics.model.StoreOptions.ReadOnly]
    def status: zio.aws.omics.model.StoreStatus
    def name: String
    def creationTime: CreationTime
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getReference
        : ZIO[Any, AwsError, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      AwsError.unwrapOptionField("reference", reference)
    def getStoreFormat: ZIO[Any, AwsError, zio.aws.omics.model.StoreFormat] =
      AwsError.unwrapOptionField("storeFormat", storeFormat)
    def getStoreOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.StoreOptions.ReadOnly] =
      AwsError.unwrapOptionField("storeOptions", storeOptions)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.StoreStatus] =
      ZIO.succeed(status)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse
  ) extends zio.aws.omics.model.CreateAnnotationStoreResponse.ReadOnly {
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val reference
        : Optional[zio.aws.omics.model.ReferenceItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reference())
        .map(value => zio.aws.omics.model.ReferenceItem.wrap(value))
    override val storeFormat: Optional[zio.aws.omics.model.StoreFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storeFormat())
        .map(value => zio.aws.omics.model.StoreFormat.wrap(value))
    override val storeOptions
        : Optional[zio.aws.omics.model.StoreOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storeOptions())
        .map(value => zio.aws.omics.model.StoreOptions.wrap(value))
    override val status: zio.aws.omics.model.StoreStatus =
      zio.aws.omics.model.StoreStatus.wrap(impl.status())
    override val name: String = impl.name(): String
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse
  ): zio.aws.omics.model.CreateAnnotationStoreResponse.ReadOnly = new Wrapper(
    impl
  )
}
