package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  UploadId,
  ReadSetName,
  SubjectId,
  SampleId,
  SequenceStoreId,
  SyntheticTimestamp_date_time,
  TagValue,
  ReadSetDescription,
  GeneratedFrom,
  ReferenceArn,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateMultipartReadSetUploadResponse(
    sequenceStoreId: SequenceStoreId,
    uploadId: UploadId,
    sourceFileType: zio.aws.omics.model.FileType,
    subjectId: SubjectId,
    sampleId: SampleId,
    generatedFrom: Optional[GeneratedFrom] = Optional.Absent,
    referenceArn: ReferenceArn,
    name: Optional[ReadSetName] = Optional.Absent,
    description: Optional[ReadSetDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadResponse = {
    import CreateMultipartReadSetUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadResponse
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .uploadId(UploadId.unwrap(uploadId): java.lang.String)
      .sourceFileType(sourceFileType.unwrap)
      .subjectId(SubjectId.unwrap(subjectId): java.lang.String)
      .sampleId(SampleId.unwrap(sampleId): java.lang.String)
      .optionallyWith(
        generatedFrom.map(value =>
          GeneratedFrom.unwrap(value): java.lang.String
        )
      )(_.generatedFrom)
      .referenceArn(ReferenceArn.unwrap(referenceArn): java.lang.String)
      .optionallyWith(
        name.map(value => ReadSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ReadSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.CreateMultipartReadSetUploadResponse.ReadOnly =
    zio.aws.omics.model.CreateMultipartReadSetUploadResponse
      .wrap(buildAwsValue())
}
object CreateMultipartReadSetUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateMultipartReadSetUploadResponse =
      zio.aws.omics.model.CreateMultipartReadSetUploadResponse(
        sequenceStoreId,
        uploadId,
        sourceFileType,
        subjectId,
        sampleId,
        generatedFrom.map(value => value),
        referenceArn,
        name.map(value => value),
        description.map(value => value),
        tags.map(value => value),
        creationTime
      )
    def sequenceStoreId: SequenceStoreId
    def uploadId: UploadId
    def sourceFileType: zio.aws.omics.model.FileType
    def subjectId: SubjectId
    def sampleId: SampleId
    def generatedFrom: Optional[GeneratedFrom]
    def referenceArn: ReferenceArn
    def name: Optional[ReadSetName]
    def description: Optional[ReadSetDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def creationTime: SyntheticTimestamp_date_time
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getUploadId: ZIO[Any, Nothing, UploadId] = ZIO.succeed(uploadId)
    def getSourceFileType: ZIO[Any, Nothing, zio.aws.omics.model.FileType] =
      ZIO.succeed(sourceFileType)
    def getSubjectId: ZIO[Any, Nothing, SubjectId] = ZIO.succeed(subjectId)
    def getSampleId: ZIO[Any, Nothing, SampleId] = ZIO.succeed(sampleId)
    def getGeneratedFrom: ZIO[Any, AwsError, GeneratedFrom] =
      AwsError.unwrapOptionField("generatedFrom", generatedFrom)
    def getReferenceArn: ZIO[Any, Nothing, ReferenceArn] =
      ZIO.succeed(referenceArn)
    def getName: ZIO[Any, AwsError, ReadSetName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ReadSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadResponse
  ) extends zio.aws.omics.model.CreateMultipartReadSetUploadResponse.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val uploadId: UploadId =
      zio.aws.omics.model.primitives.UploadId(impl.uploadId())
    override val sourceFileType: zio.aws.omics.model.FileType =
      zio.aws.omics.model.FileType.wrap(impl.sourceFileType())
    override val subjectId: SubjectId =
      zio.aws.omics.model.primitives.SubjectId(impl.subjectId())
    override val sampleId: SampleId =
      zio.aws.omics.model.primitives.SampleId(impl.sampleId())
    override val generatedFrom: Optional[GeneratedFrom] = zio.aws.core.internal
      .optionalFromNullable(impl.generatedFrom())
      .map(value => zio.aws.omics.model.primitives.GeneratedFrom(value))
    override val referenceArn: ReferenceArn =
      zio.aws.omics.model.primitives.ReferenceArn(impl.referenceArn())
    override val name: Optional[ReadSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReadSetName(value))
    override val description: Optional[ReadSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.ReadSetDescription(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadResponse
  ): zio.aws.omics.model.CreateMultipartReadSetUploadResponse.ReadOnly =
    new Wrapper(impl)
}
