package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  ReferenceStoreName,
  TagValue,
  ReferenceStoreDescription,
  ClientToken,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateReferenceStoreRequest(
    name: ReferenceStoreName,
    description: Optional[ReferenceStoreDescription] = Optional.Absent,
    sseConfig: Optional[zio.aws.omics.model.SseConfig] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest = {
    import CreateReferenceStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest
      .builder()
      .name(ReferenceStoreName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ReferenceStoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(sseConfig.map(value => value.buildAwsValue()))(
        _.sseConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateReferenceStoreRequest.ReadOnly =
    zio.aws.omics.model.CreateReferenceStoreRequest.wrap(buildAwsValue())
}
object CreateReferenceStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateReferenceStoreRequest =
      zio.aws.omics.model.CreateReferenceStoreRequest(
        name,
        description.map(value => value),
        sseConfig.map(value => value.asEditable),
        tags.map(value => value),
        clientToken.map(value => value)
      )
    def name: ReferenceStoreName
    def description: Optional[ReferenceStoreDescription]
    def sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: Optional[ClientToken]
    def getName: ZIO[Any, Nothing, ReferenceStoreName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ReferenceStoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSseConfig
        : ZIO[Any, AwsError, zio.aws.omics.model.SseConfig.ReadOnly] =
      AwsError.unwrapOptionField("sseConfig", sseConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest
  ) extends zio.aws.omics.model.CreateReferenceStoreRequest.ReadOnly {
    override val name: ReferenceStoreName =
      zio.aws.omics.model.primitives.ReferenceStoreName(impl.name())
    override val description: Optional[ReferenceStoreDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.ReferenceStoreDescription(value)
        )
    override val sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseConfig())
        .map(value => zio.aws.omics.model.SseConfig.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.omics.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest
  ): zio.aws.omics.model.CreateReferenceStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
