package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReferenceStoreArn,
  ReferenceStoreName,
  SyntheticTimestamp_date_time,
  ReferenceStoreDescription,
  ReferenceStoreId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateReferenceStoreResponse(
    id: ReferenceStoreId,
    arn: ReferenceStoreArn,
    name: Optional[ReferenceStoreName] = Optional.Absent,
    description: Optional[ReferenceStoreDescription] = Optional.Absent,
    sseConfig: Optional[zio.aws.omics.model.SseConfig] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse = {
    import CreateReferenceStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse
      .builder()
      .id(ReferenceStoreId.unwrap(id): java.lang.String)
      .arn(ReferenceStoreArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        name.map(value => ReferenceStoreName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ReferenceStoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(sseConfig.map(value => value.buildAwsValue()))(
        _.sseConfig
      )
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateReferenceStoreResponse.ReadOnly =
    zio.aws.omics.model.CreateReferenceStoreResponse.wrap(buildAwsValue())
}
object CreateReferenceStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateReferenceStoreResponse =
      zio.aws.omics.model.CreateReferenceStoreResponse(
        id,
        arn,
        name.map(value => value),
        description.map(value => value),
        sseConfig.map(value => value.asEditable),
        creationTime
      )
    def id: ReferenceStoreId
    def arn: ReferenceStoreArn
    def name: Optional[ReferenceStoreName]
    def description: Optional[ReferenceStoreDescription]
    def sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly]
    def creationTime: SyntheticTimestamp_date_time
    def getId: ZIO[Any, Nothing, ReferenceStoreId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ReferenceStoreArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, ReferenceStoreName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ReferenceStoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSseConfig
        : ZIO[Any, AwsError, zio.aws.omics.model.SseConfig.ReadOnly] =
      AwsError.unwrapOptionField("sseConfig", sseConfig)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse
  ) extends zio.aws.omics.model.CreateReferenceStoreResponse.ReadOnly {
    override val id: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.id())
    override val arn: ReferenceStoreArn =
      zio.aws.omics.model.primitives.ReferenceStoreArn(impl.arn())
    override val name: Optional[ReferenceStoreName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReferenceStoreName(value))
    override val description: Optional[ReferenceStoreDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.ReferenceStoreDescription(value)
        )
    override val sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseConfig())
        .map(value => zio.aws.omics.model.SseConfig.wrap(value))
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse
  ): zio.aws.omics.model.CreateReferenceStoreResponse.ReadOnly = new Wrapper(
    impl
  )
}
