package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  CreateRunGroupRequestMaxCpusInteger,
  RunGroupRequestId,
  TagValue,
  CreateRunGroupRequestMaxGpusInteger,
  RunGroupName,
  CreateRunGroupRequestMaxRunsInteger,
  CreateRunGroupRequestMaxDurationInteger,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateRunGroupRequest(
    name: Optional[RunGroupName] = Optional.Absent,
    maxCpus: Optional[CreateRunGroupRequestMaxCpusInteger] = Optional.Absent,
    maxRuns: Optional[CreateRunGroupRequestMaxRunsInteger] = Optional.Absent,
    maxDuration: Optional[CreateRunGroupRequestMaxDurationInteger] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    requestId: RunGroupRequestId,
    maxGpus: Optional[CreateRunGroupRequestMaxGpusInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateRunGroupRequest = {
    import CreateRunGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateRunGroupRequest
      .builder()
      .optionallyWith(
        name.map(value => RunGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        maxCpus.map(value =>
          CreateRunGroupRequestMaxCpusInteger.unwrap(value): Integer
        )
      )(_.maxCpus)
      .optionallyWith(
        maxRuns.map(value =>
          CreateRunGroupRequestMaxRunsInteger.unwrap(value): Integer
        )
      )(_.maxRuns)
      .optionallyWith(
        maxDuration.map(value =>
          CreateRunGroupRequestMaxDurationInteger.unwrap(value): Integer
        )
      )(_.maxDuration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .requestId(RunGroupRequestId.unwrap(requestId): java.lang.String)
      .optionallyWith(
        maxGpus.map(value =>
          CreateRunGroupRequestMaxGpusInteger.unwrap(value): Integer
        )
      )(_.maxGpus)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateRunGroupRequest.ReadOnly =
    zio.aws.omics.model.CreateRunGroupRequest.wrap(buildAwsValue())
}
object CreateRunGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateRunGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateRunGroupRequest =
      zio.aws.omics.model.CreateRunGroupRequest(
        name.map(value => value),
        maxCpus.map(value => value),
        maxRuns.map(value => value),
        maxDuration.map(value => value),
        tags.map(value => value),
        requestId,
        maxGpus.map(value => value)
      )
    def name: Optional[RunGroupName]
    def maxCpus: Optional[CreateRunGroupRequestMaxCpusInteger]
    def maxRuns: Optional[CreateRunGroupRequestMaxRunsInteger]
    def maxDuration: Optional[CreateRunGroupRequestMaxDurationInteger]
    def tags: Optional[Map[TagKey, TagValue]]
    def requestId: RunGroupRequestId
    def maxGpus: Optional[CreateRunGroupRequestMaxGpusInteger]
    def getName: ZIO[Any, AwsError, RunGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getMaxCpus: ZIO[Any, AwsError, CreateRunGroupRequestMaxCpusInteger] =
      AwsError.unwrapOptionField("maxCpus", maxCpus)
    def getMaxRuns: ZIO[Any, AwsError, CreateRunGroupRequestMaxRunsInteger] =
      AwsError.unwrapOptionField("maxRuns", maxRuns)
    def getMaxDuration
        : ZIO[Any, AwsError, CreateRunGroupRequestMaxDurationInteger] =
      AwsError.unwrapOptionField("maxDuration", maxDuration)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRequestId: ZIO[Any, Nothing, RunGroupRequestId] =
      ZIO.succeed(requestId)
    def getMaxGpus: ZIO[Any, AwsError, CreateRunGroupRequestMaxGpusInteger] =
      AwsError.unwrapOptionField("maxGpus", maxGpus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateRunGroupRequest
  ) extends zio.aws.omics.model.CreateRunGroupRequest.ReadOnly {
    override val name: Optional[RunGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunGroupName(value))
    override val maxCpus: Optional[CreateRunGroupRequestMaxCpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxCpus())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateRunGroupRequestMaxCpusInteger(value)
        )
    override val maxRuns: Optional[CreateRunGroupRequestMaxRunsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRuns())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateRunGroupRequestMaxRunsInteger(value)
        )
    override val maxDuration
        : Optional[CreateRunGroupRequestMaxDurationInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDuration())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateRunGroupRequestMaxDurationInteger(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val requestId: RunGroupRequestId =
      zio.aws.omics.model.primitives.RunGroupRequestId(impl.requestId())
    override val maxGpus: Optional[CreateRunGroupRequestMaxGpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxGpus())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateRunGroupRequestMaxGpusInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateRunGroupRequest
  ): zio.aws.omics.model.CreateRunGroupRequest.ReadOnly = new Wrapper(impl)
}
