package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  TagValue,
  SequenceStoreDescription,
  ClientToken,
  SequenceStoreName,
  S3Destination,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateSequenceStoreRequest(
    name: SequenceStoreName,
    description: Optional[SequenceStoreDescription] = Optional.Absent,
    sseConfig: Optional[zio.aws.omics.model.SseConfig] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    fallbackLocation: Optional[S3Destination] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest = {
    import CreateSequenceStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest
      .builder()
      .name(SequenceStoreName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          SequenceStoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(sseConfig.map(value => value.buildAwsValue()))(
        _.sseConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        fallbackLocation.map(value =>
          S3Destination.unwrap(value): java.lang.String
        )
      )(_.fallbackLocation)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateSequenceStoreRequest.ReadOnly =
    zio.aws.omics.model.CreateSequenceStoreRequest.wrap(buildAwsValue())
}
object CreateSequenceStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateSequenceStoreRequest =
      zio.aws.omics.model.CreateSequenceStoreRequest(
        name,
        description.map(value => value),
        sseConfig.map(value => value.asEditable),
        tags.map(value => value),
        clientToken.map(value => value),
        fallbackLocation.map(value => value)
      )
    def name: SequenceStoreName
    def description: Optional[SequenceStoreDescription]
    def sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: Optional[ClientToken]
    def fallbackLocation: Optional[S3Destination]
    def getName: ZIO[Any, Nothing, SequenceStoreName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, SequenceStoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSseConfig
        : ZIO[Any, AwsError, zio.aws.omics.model.SseConfig.ReadOnly] =
      AwsError.unwrapOptionField("sseConfig", sseConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFallbackLocation: ZIO[Any, AwsError, S3Destination] =
      AwsError.unwrapOptionField("fallbackLocation", fallbackLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest
  ) extends zio.aws.omics.model.CreateSequenceStoreRequest.ReadOnly {
    override val name: SequenceStoreName =
      zio.aws.omics.model.primitives.SequenceStoreName(impl.name())
    override val description: Optional[SequenceStoreDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.SequenceStoreDescription(value)
        )
    override val sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseConfig())
        .map(value => zio.aws.omics.model.SseConfig.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.omics.model.primitives.ClientToken(value))
    override val fallbackLocation: Optional[S3Destination] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fallbackLocation())
        .map(value => zio.aws.omics.model.primitives.S3Destination(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest
  ): zio.aws.omics.model.CreateSequenceStoreRequest.ReadOnly = new Wrapper(impl)
}
