package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  TagValue,
  TagKey,
  StoreDescription,
  CreateVariantStoreRequestNameString
}
import scala.jdk.CollectionConverters._
final case class CreateVariantStoreRequest(
    reference: zio.aws.omics.model.ReferenceItem,
    name: Optional[CreateVariantStoreRequestNameString] = Optional.Absent,
    description: Optional[StoreDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    sseConfig: Optional[zio.aws.omics.model.SseConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest = {
    import CreateVariantStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest
      .builder()
      .reference(reference.buildAwsValue())
      .optionallyWith(
        name.map(value =>
          CreateVariantStoreRequestNameString.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          StoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(sseConfig.map(value => value.buildAwsValue()))(
        _.sseConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateVariantStoreRequest.ReadOnly =
    zio.aws.omics.model.CreateVariantStoreRequest.wrap(buildAwsValue())
}
object CreateVariantStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateVariantStoreRequest =
      zio.aws.omics.model.CreateVariantStoreRequest(
        reference.asEditable,
        name.map(value => value),
        description.map(value => value),
        tags.map(value => value),
        sseConfig.map(value => value.asEditable)
      )
    def reference: zio.aws.omics.model.ReferenceItem.ReadOnly
    def name: Optional[CreateVariantStoreRequestNameString]
    def description: Optional[StoreDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly]
    def getReference
        : ZIO[Any, Nothing, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      ZIO.succeed(reference)
    def getName: ZIO[Any, AwsError, CreateVariantStoreRequestNameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, StoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSseConfig
        : ZIO[Any, AwsError, zio.aws.omics.model.SseConfig.ReadOnly] =
      AwsError.unwrapOptionField("sseConfig", sseConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest
  ) extends zio.aws.omics.model.CreateVariantStoreRequest.ReadOnly {
    override val reference: zio.aws.omics.model.ReferenceItem.ReadOnly =
      zio.aws.omics.model.ReferenceItem.wrap(impl.reference())
    override val name: Optional[CreateVariantStoreRequestNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateVariantStoreRequestNameString(value)
        )
    override val description: Optional[StoreDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.omics.model.primitives.StoreDescription(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseConfig())
        .map(value => zio.aws.omics.model.SseConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest
  ): zio.aws.omics.model.CreateVariantStoreRequest.ReadOnly = new Wrapper(impl)
}
