package zio.aws.omics.model
import zio.aws.omics.model.primitives.{CreationTime, ResourceId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateVariantStoreResponse(
    id: ResourceId,
    reference: Optional[zio.aws.omics.model.ReferenceItem] = Optional.Absent,
    status: zio.aws.omics.model.StoreStatus,
    name: String,
    creationTime: CreationTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse = {
    import CreateVariantStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .optionallyWith(reference.map(value => value.buildAwsValue()))(
        _.reference
      )
      .status(status.unwrap)
      .name(name: java.lang.String)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly =
    zio.aws.omics.model.CreateVariantStoreResponse.wrap(buildAwsValue())
}
object CreateVariantStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateVariantStoreResponse =
      zio.aws.omics.model.CreateVariantStoreResponse(
        id,
        reference.map(value => value.asEditable),
        status,
        name,
        creationTime
      )
    def id: ResourceId
    def reference: Optional[zio.aws.omics.model.ReferenceItem.ReadOnly]
    def status: zio.aws.omics.model.StoreStatus
    def name: String
    def creationTime: CreationTime
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getReference
        : ZIO[Any, AwsError, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      AwsError.unwrapOptionField("reference", reference)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.StoreStatus] =
      ZIO.succeed(status)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse
  ) extends zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly {
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val reference
        : Optional[zio.aws.omics.model.ReferenceItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reference())
        .map(value => zio.aws.omics.model.ReferenceItem.wrap(value))
    override val status: zio.aws.omics.model.StoreStatus =
      zio.aws.omics.model.StoreStatus.wrap(impl.status())
    override val name: String = impl.name(): String
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse
  ): zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly = new Wrapper(impl)
}
