package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  WorkflowDescription,
  WorkflowRequestId,
  WorkflowDefinition,
  WorkflowMain,
  TagValue,
  CreateWorkflowRequestStorageCapacityInteger,
  WorkflowParameterName,
  Blob,
  TagKey,
  WorkflowName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateWorkflowRequest(
    name: Optional[WorkflowName] = Optional.Absent,
    description: Optional[WorkflowDescription] = Optional.Absent,
    engine: Optional[zio.aws.omics.model.WorkflowEngine] = Optional.Absent,
    definitionZip: Optional[Blob] = Optional.Absent,
    definitionUri: Optional[WorkflowDefinition] = Optional.Absent,
    main: Optional[WorkflowMain] = Optional.Absent,
    parameterTemplate: Optional[
      Map[WorkflowParameterName, zio.aws.omics.model.WorkflowParameter]
    ] = Optional.Absent,
    storageCapacity: Optional[CreateWorkflowRequestStorageCapacityInteger] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    requestId: WorkflowRequestId,
    accelerators: Optional[zio.aws.omics.model.Accelerators] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateWorkflowRequest = {
    import CreateWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateWorkflowRequest
      .builder()
      .optionallyWith(
        name.map(value => WorkflowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          WorkflowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(
        definitionZip.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.definitionZip)
      .optionallyWith(
        definitionUri.map(value =>
          WorkflowDefinition.unwrap(value): java.lang.String
        )
      )(_.definitionUri)
      .optionallyWith(
        main.map(value => WorkflowMain.unwrap(value): java.lang.String)
      )(_.main)
      .optionallyWith(
        parameterTemplate.map(value =>
          value
            .map({ case (key, value) =>
              (WorkflowParameterName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.parameterTemplate)
      .optionallyWith(
        storageCapacity.map(value =>
          CreateWorkflowRequestStorageCapacityInteger.unwrap(value): Integer
        )
      )(_.storageCapacity)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .requestId(WorkflowRequestId.unwrap(requestId): java.lang.String)
      .optionallyWith(accelerators.map(value => value.unwrap))(_.accelerators)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateWorkflowRequest.ReadOnly =
    zio.aws.omics.model.CreateWorkflowRequest.wrap(buildAwsValue())
}
object CreateWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateWorkflowRequest =
      zio.aws.omics.model.CreateWorkflowRequest(
        name.map(value => value),
        description.map(value => value),
        engine.map(value => value),
        definitionZip.map(value => value),
        definitionUri.map(value => value),
        main.map(value => value),
        parameterTemplate.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        storageCapacity.map(value => value),
        tags.map(value => value),
        requestId,
        accelerators.map(value => value)
      )
    def name: Optional[WorkflowName]
    def description: Optional[WorkflowDescription]
    def engine: Optional[zio.aws.omics.model.WorkflowEngine]
    def definitionZip: Optional[Blob]
    def definitionUri: Optional[WorkflowDefinition]
    def main: Optional[WorkflowMain]
    def parameterTemplate: Optional[
      Map[WorkflowParameterName, zio.aws.omics.model.WorkflowParameter.ReadOnly]
    ]
    def storageCapacity: Optional[CreateWorkflowRequestStorageCapacityInteger]
    def tags: Optional[Map[TagKey, TagValue]]
    def requestId: WorkflowRequestId
    def accelerators: Optional[zio.aws.omics.model.Accelerators]
    def getName: ZIO[Any, AwsError, WorkflowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, WorkflowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEngine: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowEngine] =
      AwsError.unwrapOptionField("engine", engine)
    def getDefinitionZip: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("definitionZip", definitionZip)
    def getDefinitionUri: ZIO[Any, AwsError, WorkflowDefinition] =
      AwsError.unwrapOptionField("definitionUri", definitionUri)
    def getMain: ZIO[Any, AwsError, WorkflowMain] =
      AwsError.unwrapOptionField("main", main)
    def getParameterTemplate: ZIO[Any, AwsError, Map[
      WorkflowParameterName,
      zio.aws.omics.model.WorkflowParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterTemplate", parameterTemplate)
    def getStorageCapacity
        : ZIO[Any, AwsError, CreateWorkflowRequestStorageCapacityInteger] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRequestId: ZIO[Any, Nothing, WorkflowRequestId] =
      ZIO.succeed(requestId)
    def getAccelerators: ZIO[Any, AwsError, zio.aws.omics.model.Accelerators] =
      AwsError.unwrapOptionField("accelerators", accelerators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateWorkflowRequest
  ) extends zio.aws.omics.model.CreateWorkflowRequest.ReadOnly {
    override val name: Optional[WorkflowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.WorkflowName(value))
    override val description: Optional[WorkflowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.WorkflowDescription(value))
    override val engine: Optional[zio.aws.omics.model.WorkflowEngine] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engine())
        .map(value => zio.aws.omics.model.WorkflowEngine.wrap(value))
    override val definitionZip: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.definitionZip())
      .map(value =>
        zio.aws.omics.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val definitionUri: Optional[WorkflowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definitionUri())
        .map(value => zio.aws.omics.model.primitives.WorkflowDefinition(value))
    override val main: Optional[WorkflowMain] = zio.aws.core.internal
      .optionalFromNullable(impl.main())
      .map(value => zio.aws.omics.model.primitives.WorkflowMain(value))
    override val parameterTemplate: Optional[
      Map[WorkflowParameterName, zio.aws.omics.model.WorkflowParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterTemplate())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives.WorkflowParameterName(
              key
            ) -> zio.aws.omics.model.WorkflowParameter.wrap(value)
          })
          .toMap
      )
    override val storageCapacity
        : Optional[CreateWorkflowRequestStorageCapacityInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageCapacity())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateWorkflowRequestStorageCapacityInteger(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val requestId: WorkflowRequestId =
      zio.aws.omics.model.primitives.WorkflowRequestId(impl.requestId())
    override val accelerators: Optional[zio.aws.omics.model.Accelerators] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accelerators())
        .map(value => zio.aws.omics.model.Accelerators.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateWorkflowRequest
  ): zio.aws.omics.model.CreateWorkflowRequest.ReadOnly = new Wrapper(impl)
}
