package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.PrimitiveBoolean
import scala.jdk.CollectionConverters._
final case class DeleteAnnotationStoreRequest(
    name: String,
    force: Optional[PrimitiveBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest = {
    import DeleteAnnotationStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(
        force.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.force)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.DeleteAnnotationStoreRequest.ReadOnly =
    zio.aws.omics.model.DeleteAnnotationStoreRequest.wrap(buildAwsValue())
}
object DeleteAnnotationStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.DeleteAnnotationStoreRequest =
      zio.aws.omics.model
        .DeleteAnnotationStoreRequest(name, force.map(value => value))
    def name: String
    def force: Optional[PrimitiveBoolean]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getForce: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest
  ) extends zio.aws.omics.model.DeleteAnnotationStoreRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val force: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => zio.aws.omics.model.primitives.PrimitiveBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest
  ): zio.aws.omics.model.DeleteAnnotationStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
