package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.SequenceStoreId
import scala.jdk.CollectionConverters._
final case class DeleteSequenceStoreRequest(id: SequenceStoreId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest = {
    import DeleteSequenceStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest
      .builder()
      .id(SequenceStoreId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.DeleteSequenceStoreRequest.ReadOnly =
    zio.aws.omics.model.DeleteSequenceStoreRequest.wrap(buildAwsValue())
}
object DeleteSequenceStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.DeleteSequenceStoreRequest =
      zio.aws.omics.model.DeleteSequenceStoreRequest(id)
    def id: SequenceStoreId
    def getId: ZIO[Any, Nothing, SequenceStoreId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest
  ) extends zio.aws.omics.model.DeleteSequenceStoreRequest.ReadOnly {
    override val id: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest
  ): zio.aws.omics.model.DeleteSequenceStoreRequest.ReadOnly = new Wrapper(impl)
}
