package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.PrimitiveBoolean
import scala.jdk.CollectionConverters._
final case class DeleteVariantStoreRequest(
    name: String,
    force: Optional[PrimitiveBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest = {
    import DeleteVariantStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(
        force.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.force)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.DeleteVariantStoreRequest.ReadOnly =
    zio.aws.omics.model.DeleteVariantStoreRequest.wrap(buildAwsValue())
}
object DeleteVariantStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.DeleteVariantStoreRequest =
      zio.aws.omics.model
        .DeleteVariantStoreRequest(name, force.map(value => value))
    def name: String
    def force: Optional[PrimitiveBoolean]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getForce: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest
  ) extends zio.aws.omics.model.DeleteVariantStoreRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val force: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => zio.aws.omics.model.primitives.PrimitiveBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest
  ): zio.aws.omics.model.DeleteVariantStoreRequest.ReadOnly = new Wrapper(impl)
}
