package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ReadSetId
import scala.jdk.CollectionConverters._
final case class ExportReadSet(readSetId: ReadSetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ExportReadSet = {
    import ExportReadSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ExportReadSet
      .builder()
      .readSetId(ReadSetId.unwrap(readSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ExportReadSet.ReadOnly =
    zio.aws.omics.model.ExportReadSet.wrap(buildAwsValue())
}
object ExportReadSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ExportReadSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ExportReadSet =
      zio.aws.omics.model.ExportReadSet(readSetId)
    def readSetId: ReadSetId
    def getReadSetId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(readSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ExportReadSet
  ) extends zio.aws.omics.model.ExportReadSet.ReadOnly {
    override val readSetId: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.readSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ExportReadSet
  ): zio.aws.omics.model.ExportReadSet.ReadOnly = new Wrapper(impl)
}
