package zio.aws.omics.model
import zio.aws.omics.model.primitives.SyntheticTimestamp_date_time
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ExportReadSetFilter(
    status: Optional[zio.aws.omics.model.ReadSetExportJobStatus] =
      Optional.Absent,
    createdAfter: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBefore: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ExportReadSetFilter = {
    import ExportReadSetFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ExportReadSetFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdAfter.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdBefore)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ExportReadSetFilter.ReadOnly =
    zio.aws.omics.model.ExportReadSetFilter.wrap(buildAwsValue())
}
object ExportReadSetFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ExportReadSetFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ExportReadSetFilter =
      zio.aws.omics.model.ExportReadSetFilter(
        status.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value)
      )
    def status: Optional[zio.aws.omics.model.ReadSetExportJobStatus]
    def createdAfter: Optional[SyntheticTimestamp_date_time]
    def createdBefore: Optional[SyntheticTimestamp_date_time]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.omics.model.ReadSetExportJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAfter: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ExportReadSetFilter
  ) extends zio.aws.omics.model.ExportReadSetFilter.ReadOnly {
    override val status: Optional[zio.aws.omics.model.ReadSetExportJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.ReadSetExportJobStatus.wrap(value))
    override val createdAfter: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAfter())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBefore: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBefore())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ExportReadSetFilter
  ): zio.aws.omics.model.ExportReadSetFilter.ReadOnly = new Wrapper(impl)
}
