package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SyntheticTimestamp_date_time,
  S3Destination,
  SequenceStoreId,
  ExportJobId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ExportReadSetJobDetail(
    id: ExportJobId,
    sequenceStoreId: SequenceStoreId,
    destination: S3Destination,
    status: zio.aws.omics.model.ReadSetExportJobStatus,
    creationTime: SyntheticTimestamp_date_time,
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail = {
    import ExportReadSetJobDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail
      .builder()
      .id(ExportJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .destination(S3Destination.unwrap(destination): java.lang.String)
      .status(status.unwrap)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly =
    zio.aws.omics.model.ExportReadSetJobDetail.wrap(buildAwsValue())
}
object ExportReadSetJobDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ExportReadSetJobDetail =
      zio.aws.omics.model.ExportReadSetJobDetail(
        id,
        sequenceStoreId,
        destination,
        status,
        creationTime,
        completionTime.map(value => value)
      )
    def id: ExportJobId
    def sequenceStoreId: SequenceStoreId
    def destination: S3Destination
    def status: zio.aws.omics.model.ReadSetExportJobStatus
    def creationTime: SyntheticTimestamp_date_time
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def getId: ZIO[Any, Nothing, ExportJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getDestination: ZIO[Any, Nothing, S3Destination] =
      ZIO.succeed(destination)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetExportJobStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail
  ) extends zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly {
    override val id: ExportJobId =
      zio.aws.omics.model.primitives.ExportJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val destination: S3Destination =
      zio.aws.omics.model.primitives.S3Destination(impl.destination())
    override val status: zio.aws.omics.model.ReadSetExportJobStatus =
      zio.aws.omics.model.ReadSetExportJobStatus.wrap(impl.status())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail
  ): zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly = new Wrapper(impl)
}
