package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait FileType {
  def unwrap: software.amazon.awssdk.services.omics.model.FileType
}
object FileType {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.FileType
  ): zio.aws.omics.model.FileType = value match {
    case software.amazon.awssdk.services.omics.model.FileType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.FileType.FASTQ =>
      val r = FASTQ
      r
    case software.amazon.awssdk.services.omics.model.FileType.BAM =>
      val r = BAM
      r
    case software.amazon.awssdk.services.omics.model.FileType.CRAM =>
      val r = CRAM
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.FileType {
    override def unwrap: software.amazon.awssdk.services.omics.model.FileType =
      software.amazon.awssdk.services.omics.model.FileType.UNKNOWN_TO_SDK_VERSION
  }
  case object FASTQ extends zio.aws.omics.model.FileType {
    override def unwrap: software.amazon.awssdk.services.omics.model.FileType =
      software.amazon.awssdk.services.omics.model.FileType.FASTQ
  }
  case object BAM extends zio.aws.omics.model.FileType {
    override def unwrap: software.amazon.awssdk.services.omics.model.FileType =
      software.amazon.awssdk.services.omics.model.FileType.BAM
  }
  case object CRAM extends zio.aws.omics.model.FileType {
    override def unwrap: software.amazon.awssdk.services.omics.model.FileType =
      software.amazon.awssdk.services.omics.model.FileType.CRAM
  }
}
