package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FormatOptions(
    tsvOptions: Optional[zio.aws.omics.model.TsvOptions] = Optional.Absent,
    vcfOptions: Optional[zio.aws.omics.model.VcfOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.FormatOptions = {
    import FormatOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.FormatOptions
      .builder()
      .optionallyWith(tsvOptions.map(value => value.buildAwsValue()))(
        _.tsvOptions
      )
      .optionallyWith(vcfOptions.map(value => value.buildAwsValue()))(
        _.vcfOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.FormatOptions.ReadOnly =
    zio.aws.omics.model.FormatOptions.wrap(buildAwsValue())
}
object FormatOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.FormatOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.FormatOptions =
      zio.aws.omics.model.FormatOptions(
        tsvOptions.map(value => value.asEditable),
        vcfOptions.map(value => value.asEditable)
      )
    def tsvOptions: Optional[zio.aws.omics.model.TsvOptions.ReadOnly]
    def vcfOptions: Optional[zio.aws.omics.model.VcfOptions.ReadOnly]
    def getTsvOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.TsvOptions.ReadOnly] =
      AwsError.unwrapOptionField("tsvOptions", tsvOptions)
    def getVcfOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.VcfOptions.ReadOnly] =
      AwsError.unwrapOptionField("vcfOptions", vcfOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.FormatOptions
  ) extends zio.aws.omics.model.FormatOptions.ReadOnly {
    override val tsvOptions: Optional[zio.aws.omics.model.TsvOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tsvOptions())
        .map(value => zio.aws.omics.model.TsvOptions.wrap(value))
    override val vcfOptions: Optional[zio.aws.omics.model.VcfOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vcfOptions())
        .map(value => zio.aws.omics.model.VcfOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.FormatOptions
  ): zio.aws.omics.model.FormatOptions.ReadOnly = new Wrapper(impl)
}
