package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait FormatToHeaderKey {
  def unwrap: software.amazon.awssdk.services.omics.model.FormatToHeaderKey
}
object FormatToHeaderKey {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.FormatToHeaderKey
  ): zio.aws.omics.model.FormatToHeaderKey = value match {
    case software.amazon.awssdk.services.omics.model.FormatToHeaderKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.FormatToHeaderKey.CHR =>
      val r = CHR
      r
    case software.amazon.awssdk.services.omics.model.FormatToHeaderKey.START =>
      val r = START
      r
    case software.amazon.awssdk.services.omics.model.FormatToHeaderKey.END =>
      val r = END
      r
    case software.amazon.awssdk.services.omics.model.FormatToHeaderKey.REF =>
      val r = REF
      r
    case software.amazon.awssdk.services.omics.model.FormatToHeaderKey.ALT =>
      val r = ALT
      r
    case software.amazon.awssdk.services.omics.model.FormatToHeaderKey.POS =>
      val r = POS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.omics.model.FormatToHeaderKey {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.FormatToHeaderKey =
      software.amazon.awssdk.services.omics.model.FormatToHeaderKey.UNKNOWN_TO_SDK_VERSION
  }
  case object CHR extends zio.aws.omics.model.FormatToHeaderKey {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.FormatToHeaderKey =
      software.amazon.awssdk.services.omics.model.FormatToHeaderKey.CHR
  }
  case object START extends zio.aws.omics.model.FormatToHeaderKey {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.FormatToHeaderKey =
      software.amazon.awssdk.services.omics.model.FormatToHeaderKey.START
  }
  case object END extends zio.aws.omics.model.FormatToHeaderKey {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.FormatToHeaderKey =
      software.amazon.awssdk.services.omics.model.FormatToHeaderKey.END
  }
  case object REF extends zio.aws.omics.model.FormatToHeaderKey {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.FormatToHeaderKey =
      software.amazon.awssdk.services.omics.model.FormatToHeaderKey.REF
  }
  case object ALT extends zio.aws.omics.model.FormatToHeaderKey {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.FormatToHeaderKey =
      software.amazon.awssdk.services.omics.model.FormatToHeaderKey.ALT
  }
  case object POS extends zio.aws.omics.model.FormatToHeaderKey {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.FormatToHeaderKey =
      software.amazon.awssdk.services.omics.model.FormatToHeaderKey.POS
  }
}
