package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetAnnotationImportJobRequest(jobId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest = {
    import GetAnnotationImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest
      .builder()
      .jobId(ResourceId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetAnnotationImportJobRequest.ReadOnly =
    zio.aws.omics.model.GetAnnotationImportJobRequest.wrap(buildAwsValue())
}
object GetAnnotationImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetAnnotationImportJobRequest =
      zio.aws.omics.model.GetAnnotationImportJobRequest(jobId)
    def jobId: ResourceId
    def getJobId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest
  ) extends zio.aws.omics.model.GetAnnotationImportJobRequest.ReadOnly {
    override val jobId: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest
  ): zio.aws.omics.model.GetAnnotationImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
