package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  CreationTime,
  UpdateTime,
  AnnotationFieldMapKeyString,
  AnnotationFieldMapValueString,
  JobStatusMsg,
  StoreName,
  CompletionTime,
  Arn,
  RunLeftNormalization,
  ResourceId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetAnnotationImportJobResponse(
    id: ResourceId,
    destinationName: StoreName,
    roleArn: Arn,
    status: zio.aws.omics.model.JobStatus,
    statusMessage: JobStatusMsg,
    creationTime: CreationTime,
    updateTime: UpdateTime,
    completionTime: CompletionTime,
    items: Iterable[zio.aws.omics.model.AnnotationImportItemDetail],
    runLeftNormalization: RunLeftNormalization,
    formatOptions: zio.aws.omics.model.FormatOptions,
    annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse = {
    import GetAnnotationImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .destinationName(StoreName.unwrap(destinationName): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .status(status.unwrap)
      .statusMessage(JobStatusMsg.unwrap(statusMessage): java.lang.String)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .completionTime(CompletionTime.unwrap(completionTime): Instant)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .runLeftNormalization(
        RunLeftNormalization.unwrap(runLeftNormalization): java.lang.Boolean
      )
      .formatOptions(formatOptions.buildAwsValue())
      .optionallyWith(
        annotationFields.map(value =>
          value
            .map({ case (key, value) =>
              (AnnotationFieldMapKeyString.unwrap(
                key
              ): java.lang.String) -> (AnnotationFieldMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.annotationFields)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly =
    zio.aws.omics.model.GetAnnotationImportJobResponse.wrap(buildAwsValue())
}
object GetAnnotationImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetAnnotationImportJobResponse =
      zio.aws.omics.model.GetAnnotationImportJobResponse(
        id,
        destinationName,
        roleArn,
        status,
        statusMessage,
        creationTime,
        updateTime,
        completionTime,
        items.map { item =>
          item.asEditable
        },
        runLeftNormalization,
        formatOptions.asEditable,
        annotationFields.map(value => value)
      )
    def id: ResourceId
    def destinationName: StoreName
    def roleArn: Arn
    def status: zio.aws.omics.model.JobStatus
    def statusMessage: JobStatusMsg
    def creationTime: CreationTime
    def updateTime: UpdateTime
    def completionTime: CompletionTime
    def items: List[zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly]
    def runLeftNormalization: RunLeftNormalization
    def formatOptions: zio.aws.omics.model.FormatOptions.ReadOnly
    def annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ]
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getDestinationName: ZIO[Any, Nothing, StoreName] =
      ZIO.succeed(destinationName)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.JobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, Nothing, JobStatusMsg] =
      ZIO.succeed(statusMessage)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
    def getCompletionTime: ZIO[Any, Nothing, CompletionTime] =
      ZIO.succeed(completionTime)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly
    ]] = ZIO.succeed(items)
    def getRunLeftNormalization: ZIO[Any, Nothing, RunLeftNormalization] =
      ZIO.succeed(runLeftNormalization)
    def getFormatOptions
        : ZIO[Any, Nothing, zio.aws.omics.model.FormatOptions.ReadOnly] =
      ZIO.succeed(formatOptions)
    def getAnnotationFields: ZIO[Any, AwsError, Map[
      AnnotationFieldMapKeyString,
      AnnotationFieldMapValueString
    ]] = AwsError.unwrapOptionField("annotationFields", annotationFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse
  ) extends zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly {
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val destinationName: StoreName =
      zio.aws.omics.model.primitives.StoreName(impl.destinationName())
    override val roleArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.roleArn())
    override val status: zio.aws.omics.model.JobStatus =
      zio.aws.omics.model.JobStatus.wrap(impl.status())
    override val statusMessage: JobStatusMsg =
      zio.aws.omics.model.primitives.JobStatusMsg(impl.statusMessage())
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
    override val completionTime: CompletionTime =
      zio.aws.omics.model.primitives.CompletionTime(impl.completionTime())
    override val items
        : List[zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.omics.model.AnnotationImportItemDetail.wrap(item)
      }
      .toList
    override val runLeftNormalization: RunLeftNormalization =
      zio.aws.omics.model.primitives
        .RunLeftNormalization(impl.runLeftNormalization())
    override val formatOptions: zio.aws.omics.model.FormatOptions.ReadOnly =
      zio.aws.omics.model.FormatOptions.wrap(impl.formatOptions())
    override val annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.annotationFields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives.AnnotationFieldMapKeyString(
              key
            ) -> zio.aws.omics.model.primitives
              .AnnotationFieldMapValueString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse
  ): zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
