package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  CreationTime,
  UpdateTime,
  TagValue,
  Arn,
  ResourceId,
  StatusMessage,
  StoreDescription,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetAnnotationStoreResponse(
    id: ResourceId,
    reference: zio.aws.omics.model.ReferenceItem,
    status: zio.aws.omics.model.StoreStatus,
    storeArn: Arn,
    name: String,
    description: StoreDescription,
    sseConfig: zio.aws.omics.model.SseConfig,
    creationTime: CreationTime,
    updateTime: UpdateTime,
    tags: Map[TagKey, TagValue],
    storeOptions: Optional[zio.aws.omics.model.StoreOptions] = Optional.Absent,
    storeFormat: Optional[zio.aws.omics.model.StoreFormat] = Optional.Absent,
    statusMessage: StatusMessage,
    storeSizeBytes: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse = {
    import GetAnnotationStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .reference(reference.buildAwsValue())
      .status(status.unwrap)
      .storeArn(Arn.unwrap(storeArn): java.lang.String)
      .name(name: java.lang.String)
      .description(StoreDescription.unwrap(description): java.lang.String)
      .sseConfig(sseConfig.buildAwsValue())
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
              value
            ): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(storeOptions.map(value => value.buildAwsValue()))(
        _.storeOptions
      )
      .optionallyWith(storeFormat.map(value => value.unwrap))(_.storeFormat)
      .statusMessage(StatusMessage.unwrap(statusMessage): java.lang.String)
      .storeSizeBytes(storeSizeBytes: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetAnnotationStoreResponse.ReadOnly =
    zio.aws.omics.model.GetAnnotationStoreResponse.wrap(buildAwsValue())
}
object GetAnnotationStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetAnnotationStoreResponse =
      zio.aws.omics.model.GetAnnotationStoreResponse(
        id,
        reference.asEditable,
        status,
        storeArn,
        name,
        description,
        sseConfig.asEditable,
        creationTime,
        updateTime,
        tags,
        storeOptions.map(value => value.asEditable),
        storeFormat.map(value => value),
        statusMessage,
        storeSizeBytes
      )
    def id: ResourceId
    def reference: zio.aws.omics.model.ReferenceItem.ReadOnly
    def status: zio.aws.omics.model.StoreStatus
    def storeArn: Arn
    def name: String
    def description: StoreDescription
    def sseConfig: zio.aws.omics.model.SseConfig.ReadOnly
    def creationTime: CreationTime
    def updateTime: UpdateTime
    def tags: Map[TagKey, TagValue]
    def storeOptions: Optional[zio.aws.omics.model.StoreOptions.ReadOnly]
    def storeFormat: Optional[zio.aws.omics.model.StoreFormat]
    def statusMessage: StatusMessage
    def storeSizeBytes: Long
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getReference
        : ZIO[Any, Nothing, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      ZIO.succeed(reference)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.StoreStatus] =
      ZIO.succeed(status)
    def getStoreArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(storeArn)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, Nothing, StoreDescription] =
      ZIO.succeed(description)
    def getSseConfig
        : ZIO[Any, Nothing, zio.aws.omics.model.SseConfig.ReadOnly] =
      ZIO.succeed(sseConfig)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
    def getStoreOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.StoreOptions.ReadOnly] =
      AwsError.unwrapOptionField("storeOptions", storeOptions)
    def getStoreFormat: ZIO[Any, AwsError, zio.aws.omics.model.StoreFormat] =
      AwsError.unwrapOptionField("storeFormat", storeFormat)
    def getStatusMessage: ZIO[Any, Nothing, StatusMessage] =
      ZIO.succeed(statusMessage)
    def getStoreSizeBytes: ZIO[Any, Nothing, Long] = ZIO.succeed(storeSizeBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse
  ) extends zio.aws.omics.model.GetAnnotationStoreResponse.ReadOnly {
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val reference: zio.aws.omics.model.ReferenceItem.ReadOnly =
      zio.aws.omics.model.ReferenceItem.wrap(impl.reference())
    override val status: zio.aws.omics.model.StoreStatus =
      zio.aws.omics.model.StoreStatus.wrap(impl.status())
    override val storeArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.storeArn())
    override val name: String = impl.name(): String
    override val description: StoreDescription =
      zio.aws.omics.model.primitives.StoreDescription(impl.description())
    override val sseConfig: zio.aws.omics.model.SseConfig.ReadOnly =
      zio.aws.omics.model.SseConfig.wrap(impl.sseConfig())
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.omics.model.primitives
          .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
      })
      .toMap
    override val storeOptions
        : Optional[zio.aws.omics.model.StoreOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storeOptions())
        .map(value => zio.aws.omics.model.StoreOptions.wrap(value))
    override val storeFormat: Optional[zio.aws.omics.model.StoreFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storeFormat())
        .map(value => zio.aws.omics.model.StoreFormat.wrap(value))
    override val statusMessage: StatusMessage =
      zio.aws.omics.model.primitives.StatusMessage(impl.statusMessage())
    override val storeSizeBytes: Long = impl.storeSizeBytes(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse
  ): zio.aws.omics.model.GetAnnotationStoreResponse.ReadOnly = new Wrapper(impl)
}
