package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{SequenceStoreId, ActivationJobId}
import scala.jdk.CollectionConverters._
final case class GetReadSetActivationJobRequest(
    id: ActivationJobId,
    sequenceStoreId: SequenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest = {
    import GetReadSetActivationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest
      .builder()
      .id(ActivationJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetActivationJobRequest.ReadOnly =
    zio.aws.omics.model.GetReadSetActivationJobRequest.wrap(buildAwsValue())
}
object GetReadSetActivationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetActivationJobRequest =
      zio.aws.omics.model.GetReadSetActivationJobRequest(id, sequenceStoreId)
    def id: ActivationJobId
    def sequenceStoreId: SequenceStoreId
    def getId: ZIO[Any, Nothing, ActivationJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest
  ) extends zio.aws.omics.model.GetReadSetActivationJobRequest.ReadOnly {
    override val id: ActivationJobId =
      zio.aws.omics.model.primitives.ActivationJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest
  ): zio.aws.omics.model.GetReadSetActivationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
