package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SyntheticTimestamp_date_time,
  JobStatusMessage,
  SequenceStoreId,
  ActivationJobId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReadSetActivationJobResponse(
    id: ActivationJobId,
    sequenceStoreId: SequenceStoreId,
    status: zio.aws.omics.model.ReadSetActivationJobStatus,
    statusMessage: Optional[JobStatusMessage] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.omics.model.ActivateReadSetSourceItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse = {
    import GetReadSetActivationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse
      .builder()
      .id(ActivationJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          JobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly =
    zio.aws.omics.model.GetReadSetActivationJobResponse.wrap(buildAwsValue())
}
object GetReadSetActivationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetActivationJobResponse =
      zio.aws.omics.model.GetReadSetActivationJobResponse(
        id,
        sequenceStoreId,
        status,
        statusMessage.map(value => value),
        creationTime,
        completionTime.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: ActivationJobId
    def sequenceStoreId: SequenceStoreId
    def status: zio.aws.omics.model.ReadSetActivationJobStatus
    def statusMessage: Optional[JobStatusMessage]
    def creationTime: SyntheticTimestamp_date_time
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def sources
        : Optional[List[zio.aws.omics.model.ActivateReadSetSourceItem.ReadOnly]]
    def getId: ZIO[Any, Nothing, ActivationJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetActivationJobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ActivateReadSetSourceItem.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse
  ) extends zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly {
    override val id: ActivationJobId =
      zio.aws.omics.model.primitives.ActivationJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val status: zio.aws.omics.model.ReadSetActivationJobStatus =
      zio.aws.omics.model.ReadSetActivationJobStatus.wrap(impl.status())
    override val statusMessage: Optional[JobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.JobStatusMessage(value))
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val sources: Optional[
      List[zio.aws.omics.model.ActivateReadSetSourceItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.omics.model.ActivateReadSetSourceItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse
  ): zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
