package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{ExportJobId, SequenceStoreId}
import scala.jdk.CollectionConverters._
final case class GetReadSetExportJobRequest(
    sequenceStoreId: SequenceStoreId,
    id: ExportJobId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest = {
    import GetReadSetExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .id(ExportJobId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetExportJobRequest.ReadOnly =
    zio.aws.omics.model.GetReadSetExportJobRequest.wrap(buildAwsValue())
}
object GetReadSetExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetExportJobRequest =
      zio.aws.omics.model.GetReadSetExportJobRequest(sequenceStoreId, id)
    def sequenceStoreId: SequenceStoreId
    def id: ExportJobId
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getId: ZIO[Any, Nothing, ExportJobId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest
  ) extends zio.aws.omics.model.GetReadSetExportJobRequest.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val id: ExportJobId =
      zio.aws.omics.model.primitives.ExportJobId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest
  ): zio.aws.omics.model.GetReadSetExportJobRequest.ReadOnly = new Wrapper(impl)
}
