package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ExportJobId,
  SequenceStoreId,
  SyntheticTimestamp_date_time,
  JobStatusMessage,
  S3Destination
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReadSetExportJobResponse(
    id: ExportJobId,
    sequenceStoreId: SequenceStoreId,
    destination: S3Destination,
    status: zio.aws.omics.model.ReadSetExportJobStatus,
    statusMessage: Optional[JobStatusMessage] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    readSets: Optional[Iterable[zio.aws.omics.model.ExportReadSetDetail]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse = {
    import GetReadSetExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse
      .builder()
      .id(ExportJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .destination(S3Destination.unwrap(destination): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          JobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .optionallyWith(
        readSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.readSets)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly =
    zio.aws.omics.model.GetReadSetExportJobResponse.wrap(buildAwsValue())
}
object GetReadSetExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetExportJobResponse =
      zio.aws.omics.model.GetReadSetExportJobResponse(
        id,
        sequenceStoreId,
        destination,
        status,
        statusMessage.map(value => value),
        creationTime,
        completionTime.map(value => value),
        readSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: ExportJobId
    def sequenceStoreId: SequenceStoreId
    def destination: S3Destination
    def status: zio.aws.omics.model.ReadSetExportJobStatus
    def statusMessage: Optional[JobStatusMessage]
    def creationTime: SyntheticTimestamp_date_time
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def readSets
        : Optional[List[zio.aws.omics.model.ExportReadSetDetail.ReadOnly]]
    def getId: ZIO[Any, Nothing, ExportJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getDestination: ZIO[Any, Nothing, S3Destination] =
      ZIO.succeed(destination)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetExportJobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getReadSets: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ExportReadSetDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("readSets", readSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse
  ) extends zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly {
    override val id: ExportJobId =
      zio.aws.omics.model.primitives.ExportJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val destination: S3Destination =
      zio.aws.omics.model.primitives.S3Destination(impl.destination())
    override val status: zio.aws.omics.model.ReadSetExportJobStatus =
      zio.aws.omics.model.ReadSetExportJobStatus.wrap(impl.status())
    override val statusMessage: Optional[JobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.JobStatusMessage(value))
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val readSets
        : Optional[List[zio.aws.omics.model.ExportReadSetDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.ExportReadSetDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse
  ): zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
