package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{SequenceStoreId, ImportJobId}
import scala.jdk.CollectionConverters._
final case class GetReadSetImportJobRequest(
    id: ImportJobId,
    sequenceStoreId: SequenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest = {
    import GetReadSetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest
      .builder()
      .id(ImportJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetImportJobRequest.ReadOnly =
    zio.aws.omics.model.GetReadSetImportJobRequest.wrap(buildAwsValue())
}
object GetReadSetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetImportJobRequest =
      zio.aws.omics.model.GetReadSetImportJobRequest(id, sequenceStoreId)
    def id: ImportJobId
    def sequenceStoreId: SequenceStoreId
    def getId: ZIO[Any, Nothing, ImportJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest
  ) extends zio.aws.omics.model.GetReadSetImportJobRequest.ReadOnly {
    override val id: ImportJobId =
      zio.aws.omics.model.primitives.ImportJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest
  ): zio.aws.omics.model.GetReadSetImportJobRequest.ReadOnly = new Wrapper(impl)
}
