package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  RoleArn,
  SequenceStoreId,
  SyntheticTimestamp_date_time,
  JobStatusMessage,
  ImportJobId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReadSetImportJobResponse(
    id: ImportJobId,
    sequenceStoreId: SequenceStoreId,
    roleArn: RoleArn,
    status: zio.aws.omics.model.ReadSetImportJobStatus,
    statusMessage: Optional[JobStatusMessage] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    sources: Iterable[zio.aws.omics.model.ImportReadSetSourceItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse = {
    import GetReadSetImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse
      .builder()
      .id(ImportJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          JobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly =
    zio.aws.omics.model.GetReadSetImportJobResponse.wrap(buildAwsValue())
}
object GetReadSetImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetImportJobResponse =
      zio.aws.omics.model.GetReadSetImportJobResponse(
        id,
        sequenceStoreId,
        roleArn,
        status,
        statusMessage.map(value => value),
        creationTime,
        completionTime.map(value => value),
        sources.map { item =>
          item.asEditable
        }
      )
    def id: ImportJobId
    def sequenceStoreId: SequenceStoreId
    def roleArn: RoleArn
    def status: zio.aws.omics.model.ReadSetImportJobStatus
    def statusMessage: Optional[JobStatusMessage]
    def creationTime: SyntheticTimestamp_date_time
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def sources: List[zio.aws.omics.model.ImportReadSetSourceItem.ReadOnly]
    def getId: ZIO[Any, Nothing, ImportJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetImportJobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.omics.model.ImportReadSetSourceItem.ReadOnly
    ]] = ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse
  ) extends zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly {
    override val id: ImportJobId =
      zio.aws.omics.model.primitives.ImportJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val status: zio.aws.omics.model.ReadSetImportJobStatus =
      zio.aws.omics.model.ReadSetImportJobStatus.wrap(impl.status())
    override val statusMessage: Optional[JobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.JobStatusMessage(value))
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val sources
        : List[zio.aws.omics.model.ImportReadSetSourceItem.ReadOnly] = impl
      .sources()
      .asScala
      .map { item =>
        zio.aws.omics.model.ImportReadSetSourceItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse
  ): zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
