package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{SequenceStoreId, ReadSetId}
import scala.jdk.CollectionConverters._
final case class GetReadSetMetadataRequest(
    id: ReadSetId,
    sequenceStoreId: SequenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest = {
    import GetReadSetMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest
      .builder()
      .id(ReadSetId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetMetadataRequest.ReadOnly =
    zio.aws.omics.model.GetReadSetMetadataRequest.wrap(buildAwsValue())
}
object GetReadSetMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetMetadataRequest =
      zio.aws.omics.model.GetReadSetMetadataRequest(id, sequenceStoreId)
    def id: ReadSetId
    def sequenceStoreId: SequenceStoreId
    def getId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest
  ) extends zio.aws.omics.model.GetReadSetMetadataRequest.ReadOnly {
    override val id: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest
  ): zio.aws.omics.model.GetReadSetMetadataRequest.ReadOnly = new Wrapper(impl)
}
