package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReadSetName,
  SubjectId,
  SampleId,
  SequenceStoreId,
  SyntheticTimestamp_date_time,
  ReadSetDescription,
  ReadSetId,
  ReferenceArn,
  ReadSetArn,
  ReadSetStatusMessage
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReadSetMetadataResponse(
    id: ReadSetId,
    arn: ReadSetArn,
    sequenceStoreId: SequenceStoreId,
    subjectId: Optional[SubjectId] = Optional.Absent,
    sampleId: Optional[SampleId] = Optional.Absent,
    status: zio.aws.omics.model.ReadSetStatus,
    name: Optional[ReadSetName] = Optional.Absent,
    description: Optional[ReadSetDescription] = Optional.Absent,
    fileType: zio.aws.omics.model.FileType,
    creationTime: SyntheticTimestamp_date_time,
    sequenceInformation: Optional[zio.aws.omics.model.SequenceInformation] =
      Optional.Absent,
    referenceArn: Optional[ReferenceArn] = Optional.Absent,
    files: Optional[zio.aws.omics.model.ReadSetFiles] = Optional.Absent,
    statusMessage: Optional[ReadSetStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse = {
    import GetReadSetMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse
      .builder()
      .id(ReadSetId.unwrap(id): java.lang.String)
      .arn(ReadSetArn.unwrap(arn): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .optionallyWith(
        subjectId.map(value => SubjectId.unwrap(value): java.lang.String)
      )(_.subjectId)
      .optionallyWith(
        sampleId.map(value => SampleId.unwrap(value): java.lang.String)
      )(_.sampleId)
      .status(status.unwrap)
      .optionallyWith(
        name.map(value => ReadSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ReadSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .fileType(fileType.unwrap)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(sequenceInformation.map(value => value.buildAwsValue()))(
        _.sequenceInformation
      )
      .optionallyWith(
        referenceArn.map(value => ReferenceArn.unwrap(value): java.lang.String)
      )(_.referenceArn)
      .optionallyWith(files.map(value => value.buildAwsValue()))(_.files)
      .optionallyWith(
        statusMessage.map(value =>
          ReadSetStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly =
    zio.aws.omics.model.GetReadSetMetadataResponse.wrap(buildAwsValue())
}
object GetReadSetMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReadSetMetadataResponse =
      zio.aws.omics.model.GetReadSetMetadataResponse(
        id,
        arn,
        sequenceStoreId,
        subjectId.map(value => value),
        sampleId.map(value => value),
        status,
        name.map(value => value),
        description.map(value => value),
        fileType,
        creationTime,
        sequenceInformation.map(value => value.asEditable),
        referenceArn.map(value => value),
        files.map(value => value.asEditable),
        statusMessage.map(value => value)
      )
    def id: ReadSetId
    def arn: ReadSetArn
    def sequenceStoreId: SequenceStoreId
    def subjectId: Optional[SubjectId]
    def sampleId: Optional[SampleId]
    def status: zio.aws.omics.model.ReadSetStatus
    def name: Optional[ReadSetName]
    def description: Optional[ReadSetDescription]
    def fileType: zio.aws.omics.model.FileType
    def creationTime: SyntheticTimestamp_date_time
    def sequenceInformation
        : Optional[zio.aws.omics.model.SequenceInformation.ReadOnly]
    def referenceArn: Optional[ReferenceArn]
    def files: Optional[zio.aws.omics.model.ReadSetFiles.ReadOnly]
    def statusMessage: Optional[ReadSetStatusMessage]
    def getId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ReadSetArn] = ZIO.succeed(arn)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getSubjectId: ZIO[Any, AwsError, SubjectId] =
      AwsError.unwrapOptionField("subjectId", subjectId)
    def getSampleId: ZIO[Any, AwsError, SampleId] =
      AwsError.unwrapOptionField("sampleId", sampleId)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.ReadSetStatus] =
      ZIO.succeed(status)
    def getName: ZIO[Any, AwsError, ReadSetName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ReadSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFileType: ZIO[Any, Nothing, zio.aws.omics.model.FileType] =
      ZIO.succeed(fileType)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getSequenceInformation
        : ZIO[Any, AwsError, zio.aws.omics.model.SequenceInformation.ReadOnly] =
      AwsError.unwrapOptionField("sequenceInformation", sequenceInformation)
    def getReferenceArn: ZIO[Any, AwsError, ReferenceArn] =
      AwsError.unwrapOptionField("referenceArn", referenceArn)
    def getFiles
        : ZIO[Any, AwsError, zio.aws.omics.model.ReadSetFiles.ReadOnly] =
      AwsError.unwrapOptionField("files", files)
    def getStatusMessage: ZIO[Any, AwsError, ReadSetStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse
  ) extends zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly {
    override val id: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.id())
    override val arn: ReadSetArn =
      zio.aws.omics.model.primitives.ReadSetArn(impl.arn())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val subjectId: Optional[SubjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectId())
      .map(value => zio.aws.omics.model.primitives.SubjectId(value))
    override val sampleId: Optional[SampleId] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleId())
      .map(value => zio.aws.omics.model.primitives.SampleId(value))
    override val status: zio.aws.omics.model.ReadSetStatus =
      zio.aws.omics.model.ReadSetStatus.wrap(impl.status())
    override val name: Optional[ReadSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReadSetName(value))
    override val description: Optional[ReadSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.ReadSetDescription(value))
    override val fileType: zio.aws.omics.model.FileType =
      zio.aws.omics.model.FileType.wrap(impl.fileType())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val sequenceInformation
        : Optional[zio.aws.omics.model.SequenceInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sequenceInformation())
        .map(value => zio.aws.omics.model.SequenceInformation.wrap(value))
    override val referenceArn: Optional[ReferenceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceArn())
      .map(value => zio.aws.omics.model.primitives.ReferenceArn(value))
    override val files: Optional[zio.aws.omics.model.ReadSetFiles.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.files())
        .map(value => zio.aws.omics.model.ReadSetFiles.wrap(value))
    override val statusMessage: Optional[ReadSetStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.omics.model.primitives.ReadSetStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse
  ): zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly = new Wrapper(impl)
}
