package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{ReferenceStoreId, ImportJobId}
import scala.jdk.CollectionConverters._
final case class GetReferenceImportJobRequest(
    id: ImportJobId,
    referenceStoreId: ReferenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest = {
    import GetReferenceImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest
      .builder()
      .id(ImportJobId.unwrap(id): java.lang.String)
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReferenceImportJobRequest.ReadOnly =
    zio.aws.omics.model.GetReferenceImportJobRequest.wrap(buildAwsValue())
}
object GetReferenceImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReferenceImportJobRequest =
      zio.aws.omics.model.GetReferenceImportJobRequest(id, referenceStoreId)
    def id: ImportJobId
    def referenceStoreId: ReferenceStoreId
    def getId: ZIO[Any, Nothing, ImportJobId] = ZIO.succeed(id)
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest
  ) extends zio.aws.omics.model.GetReferenceImportJobRequest.ReadOnly {
    override val id: ImportJobId =
      zio.aws.omics.model.primitives.ImportJobId(impl.id())
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest
  ): zio.aws.omics.model.GetReferenceImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
