package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{ReferenceStoreId, ReferenceId}
import scala.jdk.CollectionConverters._
final case class GetReferenceMetadataRequest(
    id: ReferenceId,
    referenceStoreId: ReferenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest = {
    import GetReferenceMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest
      .builder()
      .id(ReferenceId.unwrap(id): java.lang.String)
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReferenceMetadataRequest.ReadOnly =
    zio.aws.omics.model.GetReferenceMetadataRequest.wrap(buildAwsValue())
}
object GetReferenceMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReferenceMetadataRequest =
      zio.aws.omics.model.GetReferenceMetadataRequest(id, referenceStoreId)
    def id: ReferenceId
    def referenceStoreId: ReferenceStoreId
    def getId: ZIO[Any, Nothing, ReferenceId] = ZIO.succeed(id)
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest
  ) extends zio.aws.omics.model.GetReferenceMetadataRequest.ReadOnly {
    override val id: ReferenceId =
      zio.aws.omics.model.primitives.ReferenceId(impl.id())
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest
  ): zio.aws.omics.model.GetReferenceMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
