package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SyntheticTimestamp_date_time,
  ReferenceId,
  ReferenceName,
  Md5,
  ReferenceArn,
  ReferenceDescription,
  ReferenceStoreId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetReferenceMetadataResponse(
    id: ReferenceId,
    arn: ReferenceArn,
    referenceStoreId: ReferenceStoreId,
    md5: Md5,
    status: Optional[zio.aws.omics.model.ReferenceStatus] = Optional.Absent,
    name: Optional[ReferenceName] = Optional.Absent,
    description: Optional[ReferenceDescription] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    updateTime: SyntheticTimestamp_date_time,
    files: Optional[zio.aws.omics.model.ReferenceFiles] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse = {
    import GetReferenceMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse
      .builder()
      .id(ReferenceId.unwrap(id): java.lang.String)
      .arn(ReferenceArn.unwrap(arn): java.lang.String)
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .md5(Md5.unwrap(md5): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        name.map(value => ReferenceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ReferenceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .updateTime(SyntheticTimestamp_date_time.unwrap(updateTime): Instant)
      .optionallyWith(files.map(value => value.buildAwsValue()))(_.files)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly =
    zio.aws.omics.model.GetReferenceMetadataResponse.wrap(buildAwsValue())
}
object GetReferenceMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReferenceMetadataResponse =
      zio.aws.omics.model.GetReferenceMetadataResponse(
        id,
        arn,
        referenceStoreId,
        md5,
        status.map(value => value),
        name.map(value => value),
        description.map(value => value),
        creationTime,
        updateTime,
        files.map(value => value.asEditable)
      )
    def id: ReferenceId
    def arn: ReferenceArn
    def referenceStoreId: ReferenceStoreId
    def md5: Md5
    def status: Optional[zio.aws.omics.model.ReferenceStatus]
    def name: Optional[ReferenceName]
    def description: Optional[ReferenceDescription]
    def creationTime: SyntheticTimestamp_date_time
    def updateTime: SyntheticTimestamp_date_time
    def files: Optional[zio.aws.omics.model.ReferenceFiles.ReadOnly]
    def getId: ZIO[Any, Nothing, ReferenceId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ReferenceArn] = ZIO.succeed(arn)
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
    def getMd5: ZIO[Any, Nothing, Md5] = ZIO.succeed(md5)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.ReferenceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getName: ZIO[Any, AwsError, ReferenceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ReferenceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getUpdateTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(updateTime)
    def getFiles
        : ZIO[Any, AwsError, zio.aws.omics.model.ReferenceFiles.ReadOnly] =
      AwsError.unwrapOptionField("files", files)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse
  ) extends zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly {
    override val id: ReferenceId =
      zio.aws.omics.model.primitives.ReferenceId(impl.id())
    override val arn: ReferenceArn =
      zio.aws.omics.model.primitives.ReferenceArn(impl.arn())
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
    override val md5: Md5 = zio.aws.omics.model.primitives.Md5(impl.md5())
    override val status: Optional[zio.aws.omics.model.ReferenceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.ReferenceStatus.wrap(value))
    override val name: Optional[ReferenceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReferenceName(value))
    override val description: Optional[ReferenceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.ReferenceDescription(value)
        )
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val updateTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.updateTime())
    override val files: Optional[zio.aws.omics.model.ReferenceFiles.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.files())
        .map(value => zio.aws.omics.model.ReferenceFiles.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse
  ): zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly = new Wrapper(
    impl
  )
}
