package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  GetReferenceRequestPartNumberInteger,
  ReferenceStoreId,
  ReferenceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetReferenceRequest(
    id: ReferenceId,
    referenceStoreId: ReferenceStoreId,
    range: Optional[zio.aws.omics.model.primitives.Range] = Optional.Absent,
    partNumber: GetReferenceRequestPartNumberInteger,
    file: Optional[zio.aws.omics.model.ReferenceFile] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetReferenceRequest = {
    import GetReferenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetReferenceRequest
      .builder()
      .id(ReferenceId.unwrap(id): java.lang.String)
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .optionallyWith(
        range.map(value =>
          zio.aws.omics.model.primitives.Range.unwrap(value): java.lang.String
        )
      )(_.range)
      .partNumber(
        GetReferenceRequestPartNumberInteger.unwrap(partNumber): Integer
      )
      .optionallyWith(file.map(value => value.unwrap))(_.file)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetReferenceRequest.ReadOnly =
    zio.aws.omics.model.GetReferenceRequest.wrap(buildAwsValue())
}
object GetReferenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetReferenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetReferenceRequest =
      zio.aws.omics.model.GetReferenceRequest(
        id,
        referenceStoreId,
        range.map(value => value),
        partNumber,
        file.map(value => value)
      )
    def id: ReferenceId
    def referenceStoreId: ReferenceStoreId
    def range: Optional[zio.aws.omics.model.primitives.Range]
    def partNumber: GetReferenceRequestPartNumberInteger
    def file: Optional[zio.aws.omics.model.ReferenceFile]
    def getId: ZIO[Any, Nothing, ReferenceId] = ZIO.succeed(id)
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
    def getRange: ZIO[Any, AwsError, zio.aws.omics.model.primitives.Range] =
      AwsError.unwrapOptionField("range", range)
    def getPartNumber: ZIO[Any, Nothing, GetReferenceRequestPartNumberInteger] =
      ZIO.succeed(partNumber)
    def getFile: ZIO[Any, AwsError, zio.aws.omics.model.ReferenceFile] =
      AwsError.unwrapOptionField("file", file)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceRequest
  ) extends zio.aws.omics.model.GetReferenceRequest.ReadOnly {
    override val id: ReferenceId =
      zio.aws.omics.model.primitives.ReferenceId(impl.id())
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
    override val range: Optional[zio.aws.omics.model.primitives.Range] =
      zio.aws.core.internal
        .optionalFromNullable(impl.range())
        .map(value => zio.aws.omics.model.primitives.Range(value))
    override val partNumber: GetReferenceRequestPartNumberInteger =
      zio.aws.omics.model.primitives
        .GetReferenceRequestPartNumberInteger(impl.partNumber())
    override val file: Optional[zio.aws.omics.model.ReferenceFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.file())
        .map(value => zio.aws.omics.model.ReferenceFile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetReferenceRequest
  ): zio.aws.omics.model.GetReferenceRequest.ReadOnly = new Wrapper(impl)
}
