package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  GetRunGroupResponseMaxGpusInteger,
  GetRunGroupResponseMaxCpusInteger,
  GetRunGroupResponseMaxRunsInteger,
  RunGroupArn,
  TagValue,
  RunGroupName,
  GetRunGroupResponseMaxDurationInteger,
  RunGroupTimestamp,
  RunGroupId,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetRunGroupResponse(
    arn: Optional[RunGroupArn] = Optional.Absent,
    id: Optional[RunGroupId] = Optional.Absent,
    name: Optional[RunGroupName] = Optional.Absent,
    maxCpus: Optional[GetRunGroupResponseMaxCpusInteger] = Optional.Absent,
    maxRuns: Optional[GetRunGroupResponseMaxRunsInteger] = Optional.Absent,
    maxDuration: Optional[GetRunGroupResponseMaxDurationInteger] =
      Optional.Absent,
    creationTime: Optional[RunGroupTimestamp] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    maxGpus: Optional[GetRunGroupResponseMaxGpusInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetRunGroupResponse = {
    import GetRunGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetRunGroupResponse
      .builder()
      .optionallyWith(
        arn.map(value => RunGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => RunGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => RunGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        maxCpus.map(value =>
          GetRunGroupResponseMaxCpusInteger.unwrap(value): Integer
        )
      )(_.maxCpus)
      .optionallyWith(
        maxRuns.map(value =>
          GetRunGroupResponseMaxRunsInteger.unwrap(value): Integer
        )
      )(_.maxRuns)
      .optionallyWith(
        maxDuration.map(value =>
          GetRunGroupResponseMaxDurationInteger.unwrap(value): Integer
        )
      )(_.maxDuration)
      .optionallyWith(
        creationTime.map(value => RunGroupTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        maxGpus.map(value =>
          GetRunGroupResponseMaxGpusInteger.unwrap(value): Integer
        )
      )(_.maxGpus)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetRunGroupResponse.ReadOnly =
    zio.aws.omics.model.GetRunGroupResponse.wrap(buildAwsValue())
}
object GetRunGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetRunGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetRunGroupResponse =
      zio.aws.omics.model.GetRunGroupResponse(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        maxCpus.map(value => value),
        maxRuns.map(value => value),
        maxDuration.map(value => value),
        creationTime.map(value => value),
        tags.map(value => value),
        maxGpus.map(value => value)
      )
    def arn: Optional[RunGroupArn]
    def id: Optional[RunGroupId]
    def name: Optional[RunGroupName]
    def maxCpus: Optional[GetRunGroupResponseMaxCpusInteger]
    def maxRuns: Optional[GetRunGroupResponseMaxRunsInteger]
    def maxDuration: Optional[GetRunGroupResponseMaxDurationInteger]
    def creationTime: Optional[RunGroupTimestamp]
    def tags: Optional[Map[TagKey, TagValue]]
    def maxGpus: Optional[GetRunGroupResponseMaxGpusInteger]
    def getArn: ZIO[Any, AwsError, RunGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, RunGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, RunGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getMaxCpus: ZIO[Any, AwsError, GetRunGroupResponseMaxCpusInteger] =
      AwsError.unwrapOptionField("maxCpus", maxCpus)
    def getMaxRuns: ZIO[Any, AwsError, GetRunGroupResponseMaxRunsInteger] =
      AwsError.unwrapOptionField("maxRuns", maxRuns)
    def getMaxDuration
        : ZIO[Any, AwsError, GetRunGroupResponseMaxDurationInteger] =
      AwsError.unwrapOptionField("maxDuration", maxDuration)
    def getCreationTime: ZIO[Any, AwsError, RunGroupTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMaxGpus: ZIO[Any, AwsError, GetRunGroupResponseMaxGpusInteger] =
      AwsError.unwrapOptionField("maxGpus", maxGpus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetRunGroupResponse
  ) extends zio.aws.omics.model.GetRunGroupResponse.ReadOnly {
    override val arn: Optional[RunGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.RunGroupArn(value))
    override val id: Optional[RunGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.RunGroupId(value))
    override val name: Optional[RunGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunGroupName(value))
    override val maxCpus: Optional[GetRunGroupResponseMaxCpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxCpus())
        .map(value =>
          zio.aws.omics.model.primitives
            .GetRunGroupResponseMaxCpusInteger(value)
        )
    override val maxRuns: Optional[GetRunGroupResponseMaxRunsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRuns())
        .map(value =>
          zio.aws.omics.model.primitives
            .GetRunGroupResponseMaxRunsInteger(value)
        )
    override val maxDuration: Optional[GetRunGroupResponseMaxDurationInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDuration())
        .map(value =>
          zio.aws.omics.model.primitives
            .GetRunGroupResponseMaxDurationInteger(value)
        )
    override val creationTime: Optional[RunGroupTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => zio.aws.omics.model.primitives.RunGroupTimestamp(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val maxGpus: Optional[GetRunGroupResponseMaxGpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxGpus())
        .map(value =>
          zio.aws.omics.model.primitives
            .GetRunGroupResponseMaxGpusInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetRunGroupResponse
  ): zio.aws.omics.model.GetRunGroupResponse.ReadOnly = new Wrapper(impl)
}
