package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  TaskLogStream,
  GetRunTaskResponseCpusInteger,
  TaskName,
  GetRunTaskResponseMemoryInteger,
  TaskTimestamp,
  TaskStatusMessage,
  GetRunTaskResponseGpusInteger,
  TaskId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetRunTaskResponse(
    taskId: Optional[TaskId] = Optional.Absent,
    status: Optional[zio.aws.omics.model.TaskStatus] = Optional.Absent,
    name: Optional[TaskName] = Optional.Absent,
    cpus: Optional[GetRunTaskResponseCpusInteger] = Optional.Absent,
    memory: Optional[GetRunTaskResponseMemoryInteger] = Optional.Absent,
    creationTime: Optional[TaskTimestamp] = Optional.Absent,
    startTime: Optional[TaskTimestamp] = Optional.Absent,
    stopTime: Optional[TaskTimestamp] = Optional.Absent,
    statusMessage: Optional[TaskStatusMessage] = Optional.Absent,
    logStream: Optional[TaskLogStream] = Optional.Absent,
    gpus: Optional[GetRunTaskResponseGpusInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetRunTaskResponse = {
    import GetRunTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetRunTaskResponse
      .builder()
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        name.map(value => TaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        cpus.map(value => GetRunTaskResponseCpusInteger.unwrap(value): Integer)
      )(_.cpus)
      .optionallyWith(
        memory.map(value =>
          GetRunTaskResponseMemoryInteger.unwrap(value): Integer
        )
      )(_.memory)
      .optionallyWith(
        creationTime.map(value => TaskTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        startTime.map(value => TaskTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        stopTime.map(value => TaskTimestamp.unwrap(value): Instant)
      )(_.stopTime)
      .optionallyWith(
        statusMessage.map(value =>
          TaskStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        logStream.map(value => TaskLogStream.unwrap(value): java.lang.String)
      )(_.logStream)
      .optionallyWith(
        gpus.map(value => GetRunTaskResponseGpusInteger.unwrap(value): Integer)
      )(_.gpus)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetRunTaskResponse.ReadOnly =
    zio.aws.omics.model.GetRunTaskResponse.wrap(buildAwsValue())
}
object GetRunTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetRunTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetRunTaskResponse =
      zio.aws.omics.model.GetRunTaskResponse(
        taskId.map(value => value),
        status.map(value => value),
        name.map(value => value),
        cpus.map(value => value),
        memory.map(value => value),
        creationTime.map(value => value),
        startTime.map(value => value),
        stopTime.map(value => value),
        statusMessage.map(value => value),
        logStream.map(value => value),
        gpus.map(value => value)
      )
    def taskId: Optional[TaskId]
    def status: Optional[zio.aws.omics.model.TaskStatus]
    def name: Optional[TaskName]
    def cpus: Optional[GetRunTaskResponseCpusInteger]
    def memory: Optional[GetRunTaskResponseMemoryInteger]
    def creationTime: Optional[TaskTimestamp]
    def startTime: Optional[TaskTimestamp]
    def stopTime: Optional[TaskTimestamp]
    def statusMessage: Optional[TaskStatusMessage]
    def logStream: Optional[TaskLogStream]
    def gpus: Optional[GetRunTaskResponseGpusInteger]
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getName: ZIO[Any, AwsError, TaskName] =
      AwsError.unwrapOptionField("name", name)
    def getCpus: ZIO[Any, AwsError, GetRunTaskResponseCpusInteger] =
      AwsError.unwrapOptionField("cpus", cpus)
    def getMemory: ZIO[Any, AwsError, GetRunTaskResponseMemoryInteger] =
      AwsError.unwrapOptionField("memory", memory)
    def getCreationTime: ZIO[Any, AwsError, TaskTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getStartTime: ZIO[Any, AwsError, TaskTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStopTime: ZIO[Any, AwsError, TaskTimestamp] =
      AwsError.unwrapOptionField("stopTime", stopTime)
    def getStatusMessage: ZIO[Any, AwsError, TaskStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getLogStream: ZIO[Any, AwsError, TaskLogStream] =
      AwsError.unwrapOptionField("logStream", logStream)
    def getGpus: ZIO[Any, AwsError, GetRunTaskResponseGpusInteger] =
      AwsError.unwrapOptionField("gpus", gpus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetRunTaskResponse
  ) extends zio.aws.omics.model.GetRunTaskResponse.ReadOnly {
    override val taskId: Optional[TaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value => zio.aws.omics.model.primitives.TaskId(value))
    override val status: Optional[zio.aws.omics.model.TaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.TaskStatus.wrap(value))
    override val name: Optional[TaskName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.TaskName(value))
    override val cpus: Optional[GetRunTaskResponseCpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpus())
        .map(value =>
          zio.aws.omics.model.primitives.GetRunTaskResponseCpusInteger(value)
        )
    override val memory: Optional[GetRunTaskResponseMemoryInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memory())
        .map(value =>
          zio.aws.omics.model.primitives.GetRunTaskResponseMemoryInteger(value)
        )
    override val creationTime: Optional[TaskTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.omics.model.primitives.TaskTimestamp(value))
    override val startTime: Optional[TaskTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.omics.model.primitives.TaskTimestamp(value))
    override val stopTime: Optional[TaskTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTime())
      .map(value => zio.aws.omics.model.primitives.TaskTimestamp(value))
    override val statusMessage: Optional[TaskStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.TaskStatusMessage(value))
    override val logStream: Optional[TaskLogStream] = zio.aws.core.internal
      .optionalFromNullable(impl.logStream())
      .map(value => zio.aws.omics.model.primitives.TaskLogStream(value))
    override val gpus: Optional[GetRunTaskResponseGpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gpus())
        .map(value =>
          zio.aws.omics.model.primitives.GetRunTaskResponseGpusInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetRunTaskResponse
  ): zio.aws.omics.model.GetRunTaskResponse.ReadOnly = new Wrapper(impl)
}
