package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SequenceStoreId,
  SyntheticTimestamp_date_time,
  SequenceStoreDescription,
  SequenceStoreArn,
  SequenceStoreName,
  S3Destination
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetSequenceStoreResponse(
    id: SequenceStoreId,
    arn: SequenceStoreArn,
    name: Optional[SequenceStoreName] = Optional.Absent,
    description: Optional[SequenceStoreDescription] = Optional.Absent,
    sseConfig: Optional[zio.aws.omics.model.SseConfig] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    fallbackLocation: Optional[S3Destination] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse = {
    import GetSequenceStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse
      .builder()
      .id(SequenceStoreId.unwrap(id): java.lang.String)
      .arn(SequenceStoreArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        name.map(value => SequenceStoreName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          SequenceStoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(sseConfig.map(value => value.buildAwsValue()))(
        _.sseConfig
      )
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        fallbackLocation.map(value =>
          S3Destination.unwrap(value): java.lang.String
        )
      )(_.fallbackLocation)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly =
    zio.aws.omics.model.GetSequenceStoreResponse.wrap(buildAwsValue())
}
object GetSequenceStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetSequenceStoreResponse =
      zio.aws.omics.model.GetSequenceStoreResponse(
        id,
        arn,
        name.map(value => value),
        description.map(value => value),
        sseConfig.map(value => value.asEditable),
        creationTime,
        fallbackLocation.map(value => value)
      )
    def id: SequenceStoreId
    def arn: SequenceStoreArn
    def name: Optional[SequenceStoreName]
    def description: Optional[SequenceStoreDescription]
    def sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly]
    def creationTime: SyntheticTimestamp_date_time
    def fallbackLocation: Optional[S3Destination]
    def getId: ZIO[Any, Nothing, SequenceStoreId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, SequenceStoreArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, SequenceStoreName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, SequenceStoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSseConfig
        : ZIO[Any, AwsError, zio.aws.omics.model.SseConfig.ReadOnly] =
      AwsError.unwrapOptionField("sseConfig", sseConfig)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getFallbackLocation: ZIO[Any, AwsError, S3Destination] =
      AwsError.unwrapOptionField("fallbackLocation", fallbackLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse
  ) extends zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly {
    override val id: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.id())
    override val arn: SequenceStoreArn =
      zio.aws.omics.model.primitives.SequenceStoreArn(impl.arn())
    override val name: Optional[SequenceStoreName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.SequenceStoreName(value))
    override val description: Optional[SequenceStoreDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.SequenceStoreDescription(value)
        )
    override val sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseConfig())
        .map(value => zio.aws.omics.model.SseConfig.wrap(value))
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val fallbackLocation: Optional[S3Destination] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fallbackLocation())
        .map(value => zio.aws.omics.model.primitives.S3Destination(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse
  ): zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly = new Wrapper(impl)
}
