package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  CreationTime,
  UpdateTime,
  AnnotationFieldMapKeyString,
  AnnotationFieldMapValueString,
  JobStatusMsg,
  StoreName,
  CompletionTime,
  Arn,
  RunLeftNormalization,
  ResourceId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetVariantImportJobResponse(
    id: ResourceId,
    destinationName: StoreName,
    roleArn: Arn,
    status: zio.aws.omics.model.JobStatus,
    statusMessage: JobStatusMsg,
    creationTime: CreationTime,
    updateTime: UpdateTime,
    completionTime: Optional[CompletionTime] = Optional.Absent,
    items: Iterable[zio.aws.omics.model.VariantImportItemDetail],
    runLeftNormalization: RunLeftNormalization,
    annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse = {
    import GetVariantImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .destinationName(StoreName.unwrap(destinationName): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .status(status.unwrap)
      .statusMessage(JobStatusMsg.unwrap(statusMessage): java.lang.String)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .optionallyWith(
        completionTime.map(value => CompletionTime.unwrap(value): Instant)
      )(_.completionTime)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .runLeftNormalization(
        RunLeftNormalization.unwrap(runLeftNormalization): java.lang.Boolean
      )
      .optionallyWith(
        annotationFields.map(value =>
          value
            .map({ case (key, value) =>
              (AnnotationFieldMapKeyString.unwrap(
                key
              ): java.lang.String) -> (AnnotationFieldMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.annotationFields)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly =
    zio.aws.omics.model.GetVariantImportJobResponse.wrap(buildAwsValue())
}
object GetVariantImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetVariantImportJobResponse =
      zio.aws.omics.model.GetVariantImportJobResponse(
        id,
        destinationName,
        roleArn,
        status,
        statusMessage,
        creationTime,
        updateTime,
        completionTime.map(value => value),
        items.map { item =>
          item.asEditable
        },
        runLeftNormalization,
        annotationFields.map(value => value)
      )
    def id: ResourceId
    def destinationName: StoreName
    def roleArn: Arn
    def status: zio.aws.omics.model.JobStatus
    def statusMessage: JobStatusMsg
    def creationTime: CreationTime
    def updateTime: UpdateTime
    def completionTime: Optional[CompletionTime]
    def items: List[zio.aws.omics.model.VariantImportItemDetail.ReadOnly]
    def runLeftNormalization: RunLeftNormalization
    def annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ]
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getDestinationName: ZIO[Any, Nothing, StoreName] =
      ZIO.succeed(destinationName)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.JobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, Nothing, JobStatusMsg] =
      ZIO.succeed(statusMessage)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
    def getCompletionTime: ZIO[Any, AwsError, CompletionTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.omics.model.VariantImportItemDetail.ReadOnly
    ]] = ZIO.succeed(items)
    def getRunLeftNormalization: ZIO[Any, Nothing, RunLeftNormalization] =
      ZIO.succeed(runLeftNormalization)
    def getAnnotationFields: ZIO[Any, AwsError, Map[
      AnnotationFieldMapKeyString,
      AnnotationFieldMapValueString
    ]] = AwsError.unwrapOptionField("annotationFields", annotationFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse
  ) extends zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly {
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val destinationName: StoreName =
      zio.aws.omics.model.primitives.StoreName(impl.destinationName())
    override val roleArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.roleArn())
    override val status: zio.aws.omics.model.JobStatus =
      zio.aws.omics.model.JobStatus.wrap(impl.status())
    override val statusMessage: JobStatusMsg =
      zio.aws.omics.model.primitives.JobStatusMsg(impl.statusMessage())
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
    override val completionTime: Optional[CompletionTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value => zio.aws.omics.model.primitives.CompletionTime(value))
    override val items
        : List[zio.aws.omics.model.VariantImportItemDetail.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.omics.model.VariantImportItemDetail.wrap(item)
      }
      .toList
    override val runLeftNormalization: RunLeftNormalization =
      zio.aws.omics.model.primitives
        .RunLeftNormalization(impl.runLeftNormalization())
    override val annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.annotationFields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives.AnnotationFieldMapKeyString(
              key
            ) -> zio.aws.omics.model.primitives
              .AnnotationFieldMapValueString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse
  ): zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
