package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  WorkflowDescription,
  GetWorkflowResponseStorageCapacityInteger,
  WorkflowArn,
  WorkflowDefinition,
  WorkflowStatusMessage,
  WorkflowMetadataKey,
  WorkflowMain,
  TagValue,
  WorkflowParameterName,
  WorkflowId,
  WorkflowMetadataValue,
  WorkflowTimestamp,
  TagKey,
  WorkflowDigest,
  WorkflowName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetWorkflowResponse(
    arn: Optional[WorkflowArn] = Optional.Absent,
    id: Optional[WorkflowId] = Optional.Absent,
    status: Optional[zio.aws.omics.model.WorkflowStatus] = Optional.Absent,
    `type`: Optional[zio.aws.omics.model.WorkflowType] = Optional.Absent,
    name: Optional[WorkflowName] = Optional.Absent,
    description: Optional[WorkflowDescription] = Optional.Absent,
    engine: Optional[zio.aws.omics.model.WorkflowEngine] = Optional.Absent,
    definition: Optional[WorkflowDefinition] = Optional.Absent,
    main: Optional[WorkflowMain] = Optional.Absent,
    digest: Optional[WorkflowDigest] = Optional.Absent,
    parameterTemplate: Optional[
      Map[WorkflowParameterName, zio.aws.omics.model.WorkflowParameter]
    ] = Optional.Absent,
    storageCapacity: Optional[GetWorkflowResponseStorageCapacityInteger] =
      Optional.Absent,
    creationTime: Optional[WorkflowTimestamp] = Optional.Absent,
    statusMessage: Optional[WorkflowStatusMessage] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    metadata: Optional[Map[WorkflowMetadataKey, WorkflowMetadataValue]] =
      Optional.Absent,
    accelerators: Optional[zio.aws.omics.model.Accelerators] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.GetWorkflowResponse = {
    import GetWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.GetWorkflowResponse
      .builder()
      .optionallyWith(
        arn.map(value => WorkflowArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => WorkflowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => WorkflowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          WorkflowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(engine.map(value => value.unwrap))(_.engine)
      .optionallyWith(
        definition.map(value =>
          WorkflowDefinition.unwrap(value): java.lang.String
        )
      )(_.definition)
      .optionallyWith(
        main.map(value => WorkflowMain.unwrap(value): java.lang.String)
      )(_.main)
      .optionallyWith(
        digest.map(value => WorkflowDigest.unwrap(value): java.lang.String)
      )(_.digest)
      .optionallyWith(
        parameterTemplate.map(value =>
          value
            .map({ case (key, value) =>
              (WorkflowParameterName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.parameterTemplate)
      .optionallyWith(
        storageCapacity.map(value =>
          GetWorkflowResponseStorageCapacityInteger.unwrap(value): Integer
        )
      )(_.storageCapacity)
      .optionallyWith(
        creationTime.map(value => WorkflowTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        statusMessage.map(value =>
          WorkflowStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (WorkflowMetadataKey
                .unwrap(key): java.lang.String) -> (WorkflowMetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(accelerators.map(value => value.unwrap))(_.accelerators)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.GetWorkflowResponse.ReadOnly =
    zio.aws.omics.model.GetWorkflowResponse.wrap(buildAwsValue())
}
object GetWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.GetWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.GetWorkflowResponse =
      zio.aws.omics.model.GetWorkflowResponse(
        arn.map(value => value),
        id.map(value => value),
        status.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        description.map(value => value),
        engine.map(value => value),
        definition.map(value => value),
        main.map(value => value),
        digest.map(value => value),
        parameterTemplate.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        storageCapacity.map(value => value),
        creationTime.map(value => value),
        statusMessage.map(value => value),
        tags.map(value => value),
        metadata.map(value => value),
        accelerators.map(value => value)
      )
    def arn: Optional[WorkflowArn]
    def id: Optional[WorkflowId]
    def status: Optional[zio.aws.omics.model.WorkflowStatus]
    def `type`: Optional[zio.aws.omics.model.WorkflowType]
    def name: Optional[WorkflowName]
    def description: Optional[WorkflowDescription]
    def engine: Optional[zio.aws.omics.model.WorkflowEngine]
    def definition: Optional[WorkflowDefinition]
    def main: Optional[WorkflowMain]
    def digest: Optional[WorkflowDigest]
    def parameterTemplate: Optional[
      Map[WorkflowParameterName, zio.aws.omics.model.WorkflowParameter.ReadOnly]
    ]
    def storageCapacity: Optional[GetWorkflowResponseStorageCapacityInteger]
    def creationTime: Optional[WorkflowTimestamp]
    def statusMessage: Optional[WorkflowStatusMessage]
    def tags: Optional[Map[TagKey, TagValue]]
    def metadata: Optional[Map[WorkflowMetadataKey, WorkflowMetadataValue]]
    def accelerators: Optional[zio.aws.omics.model.Accelerators]
    def getArn: ZIO[Any, AwsError, WorkflowArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, WorkflowId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, WorkflowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, WorkflowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEngine: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowEngine] =
      AwsError.unwrapOptionField("engine", engine)
    def getDefinition: ZIO[Any, AwsError, WorkflowDefinition] =
      AwsError.unwrapOptionField("definition", definition)
    def getMain: ZIO[Any, AwsError, WorkflowMain] =
      AwsError.unwrapOptionField("main", main)
    def getDigest: ZIO[Any, AwsError, WorkflowDigest] =
      AwsError.unwrapOptionField("digest", digest)
    def getParameterTemplate: ZIO[Any, AwsError, Map[
      WorkflowParameterName,
      zio.aws.omics.model.WorkflowParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterTemplate", parameterTemplate)
    def getStorageCapacity
        : ZIO[Any, AwsError, GetWorkflowResponseStorageCapacityInteger] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getCreationTime: ZIO[Any, AwsError, WorkflowTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getStatusMessage: ZIO[Any, AwsError, WorkflowStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMetadata
        : ZIO[Any, AwsError, Map[WorkflowMetadataKey, WorkflowMetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getAccelerators: ZIO[Any, AwsError, zio.aws.omics.model.Accelerators] =
      AwsError.unwrapOptionField("accelerators", accelerators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.GetWorkflowResponse
  ) extends zio.aws.omics.model.GetWorkflowResponse.ReadOnly {
    override val arn: Optional[WorkflowArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.WorkflowArn(value))
    override val id: Optional[WorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.WorkflowId(value))
    override val status: Optional[zio.aws.omics.model.WorkflowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.WorkflowStatus.wrap(value))
    override val `type`: Optional[zio.aws.omics.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.omics.model.WorkflowType.wrap(value))
    override val name: Optional[WorkflowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.WorkflowName(value))
    override val description: Optional[WorkflowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.WorkflowDescription(value))
    override val engine: Optional[zio.aws.omics.model.WorkflowEngine] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engine())
        .map(value => zio.aws.omics.model.WorkflowEngine.wrap(value))
    override val definition: Optional[WorkflowDefinition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definition())
        .map(value => zio.aws.omics.model.primitives.WorkflowDefinition(value))
    override val main: Optional[WorkflowMain] = zio.aws.core.internal
      .optionalFromNullable(impl.main())
      .map(value => zio.aws.omics.model.primitives.WorkflowMain(value))
    override val digest: Optional[WorkflowDigest] = zio.aws.core.internal
      .optionalFromNullable(impl.digest())
      .map(value => zio.aws.omics.model.primitives.WorkflowDigest(value))
    override val parameterTemplate: Optional[
      Map[WorkflowParameterName, zio.aws.omics.model.WorkflowParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterTemplate())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives.WorkflowParameterName(
              key
            ) -> zio.aws.omics.model.WorkflowParameter.wrap(value)
          })
          .toMap
      )
    override val storageCapacity
        : Optional[GetWorkflowResponseStorageCapacityInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageCapacity())
        .map(value =>
          zio.aws.omics.model.primitives
            .GetWorkflowResponseStorageCapacityInteger(value)
        )
    override val creationTime: Optional[WorkflowTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => zio.aws.omics.model.primitives.WorkflowTimestamp(value))
    override val statusMessage: Optional[WorkflowStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.omics.model.primitives.WorkflowStatusMessage(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val metadata
        : Optional[Map[WorkflowMetadataKey, WorkflowMetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.omics.model.primitives.WorkflowMetadataKey(
                key
              ) -> zio.aws.omics.model.primitives.WorkflowMetadataValue(value)
            })
            .toMap
        )
    override val accelerators: Optional[zio.aws.omics.model.Accelerators] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accelerators())
        .map(value => zio.aws.omics.model.Accelerators.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.GetWorkflowResponse
  ): zio.aws.omics.model.GetWorkflowResponse.ReadOnly = new Wrapper(impl)
}
