package zio.aws.omics.model
import zio.aws.omics.model.primitives.SyntheticTimestamp_date_time
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ImportReadSetFilter(
    status: Optional[zio.aws.omics.model.ReadSetImportJobStatus] =
      Optional.Absent,
    createdAfter: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBefore: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ImportReadSetFilter = {
    import ImportReadSetFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ImportReadSetFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdAfter.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdBefore)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ImportReadSetFilter.ReadOnly =
    zio.aws.omics.model.ImportReadSetFilter.wrap(buildAwsValue())
}
object ImportReadSetFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ImportReadSetFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ImportReadSetFilter =
      zio.aws.omics.model.ImportReadSetFilter(
        status.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value)
      )
    def status: Optional[zio.aws.omics.model.ReadSetImportJobStatus]
    def createdAfter: Optional[SyntheticTimestamp_date_time]
    def createdBefore: Optional[SyntheticTimestamp_date_time]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.omics.model.ReadSetImportJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAfter: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ImportReadSetFilter
  ) extends zio.aws.omics.model.ImportReadSetFilter.ReadOnly {
    override val status: Optional[zio.aws.omics.model.ReadSetImportJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.ReadSetImportJobStatus.wrap(value))
    override val createdAfter: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAfter())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBefore: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBefore())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ImportReadSetFilter
  ): zio.aws.omics.model.ImportReadSetFilter.ReadOnly = new Wrapper(impl)
}
