package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SyntheticTimestamp_date_time,
  RoleArn,
  SequenceStoreId,
  ImportJobId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ImportReadSetJobItem(
    id: ImportJobId,
    sequenceStoreId: SequenceStoreId,
    roleArn: RoleArn,
    status: zio.aws.omics.model.ReadSetImportJobStatus,
    creationTime: SyntheticTimestamp_date_time,
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ImportReadSetJobItem = {
    import ImportReadSetJobItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ImportReadSetJobItem
      .builder()
      .id(ImportJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .status(status.unwrap)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ImportReadSetJobItem.ReadOnly =
    zio.aws.omics.model.ImportReadSetJobItem.wrap(buildAwsValue())
}
object ImportReadSetJobItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ImportReadSetJobItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ImportReadSetJobItem =
      zio.aws.omics.model.ImportReadSetJobItem(
        id,
        sequenceStoreId,
        roleArn,
        status,
        creationTime,
        completionTime.map(value => value)
      )
    def id: ImportJobId
    def sequenceStoreId: SequenceStoreId
    def roleArn: RoleArn
    def status: zio.aws.omics.model.ReadSetImportJobStatus
    def creationTime: SyntheticTimestamp_date_time
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def getId: ZIO[Any, Nothing, ImportJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetImportJobStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ImportReadSetJobItem
  ) extends zio.aws.omics.model.ImportReadSetJobItem.ReadOnly {
    override val id: ImportJobId =
      zio.aws.omics.model.primitives.ImportJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val status: zio.aws.omics.model.ReadSetImportJobStatus =
      zio.aws.omics.model.ReadSetImportJobStatus.wrap(impl.status())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ImportReadSetJobItem
  ): zio.aws.omics.model.ImportReadSetJobItem.ReadOnly = new Wrapper(impl)
}
