package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAnnotationImportJobsFilter(
    status: Optional[zio.aws.omics.model.JobStatus] = Optional.Absent,
    storeName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsFilter = {
    import ListAnnotationImportJobsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(storeName.map(value => value: java.lang.String))(
        _.storeName
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListAnnotationImportJobsFilter.ReadOnly =
    zio.aws.omics.model.ListAnnotationImportJobsFilter.wrap(buildAwsValue())
}
object ListAnnotationImportJobsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListAnnotationImportJobsFilter =
      zio.aws.omics.model.ListAnnotationImportJobsFilter(
        status.map(value => value),
        storeName.map(value => value)
      )
    def status: Optional[zio.aws.omics.model.JobStatus]
    def storeName: Optional[String]
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStoreName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storeName", storeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsFilter
  ) extends zio.aws.omics.model.ListAnnotationImportJobsFilter.ReadOnly {
    override val status: Optional[zio.aws.omics.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.JobStatus.wrap(value))
    override val storeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storeName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsFilter
  ): zio.aws.omics.model.ListAnnotationImportJobsFilter.ReadOnly = new Wrapper(
    impl
  )
}
