package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ListAnnotationImportJobsRequestNextTokenString,
  ResourceIdentifier,
  ListAnnotationImportJobsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAnnotationImportJobsRequest(
    maxResults: Optional[ListAnnotationImportJobsRequestMaxResultsInteger] =
      Optional.Absent,
    ids: Optional[Iterable[ResourceIdentifier]] = Optional.Absent,
    nextToken: Optional[ListAnnotationImportJobsRequestNextTokenString] =
      Optional.Absent,
    filter: Optional[zio.aws.omics.model.ListAnnotationImportJobsFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest = {
    import ListAnnotationImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListAnnotationImportJobsRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            ResourceIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        nextToken.map(value =>
          ListAnnotationImportJobsRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListAnnotationImportJobsRequest.ReadOnly =
    zio.aws.omics.model.ListAnnotationImportJobsRequest.wrap(buildAwsValue())
}
object ListAnnotationImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListAnnotationImportJobsRequest =
      zio.aws.omics.model.ListAnnotationImportJobsRequest(
        maxResults.map(value => value),
        ids.map(value => value),
        nextToken.map(value => value),
        filter.map(value => value.asEditable)
      )
    def maxResults: Optional[ListAnnotationImportJobsRequestMaxResultsInteger]
    def ids: Optional[List[ResourceIdentifier]]
    def nextToken: Optional[ListAnnotationImportJobsRequestNextTokenString]
    def filter
        : Optional[zio.aws.omics.model.ListAnnotationImportJobsFilter.ReadOnly]
    def getMaxResults
        : ZIO[Any, AwsError, ListAnnotationImportJobsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getIds: ZIO[Any, AwsError, List[ResourceIdentifier]] =
      AwsError.unwrapOptionField("ids", ids)
    def getNextToken
        : ZIO[Any, AwsError, ListAnnotationImportJobsRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ListAnnotationImportJobsFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest
  ) extends zio.aws.omics.model.ListAnnotationImportJobsRequest.ReadOnly {
    override val maxResults
        : Optional[ListAnnotationImportJobsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListAnnotationImportJobsRequestMaxResultsInteger(value)
        )
    override val ids: Optional[List[ResourceIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.omics.model.primitives.ResourceIdentifier(item)
        }.toList
      )
    override val nextToken
        : Optional[ListAnnotationImportJobsRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListAnnotationImportJobsRequestNextTokenString(value)
        )
    override val filter: Optional[
      zio.aws.omics.model.ListAnnotationImportJobsFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        zio.aws.omics.model.ListAnnotationImportJobsFilter.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest
  ): zio.aws.omics.model.ListAnnotationImportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
