package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAnnotationStoresFilter(
    status: Optional[zio.aws.omics.model.StoreStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListAnnotationStoresFilter = {
    import ListAnnotationStoresFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListAnnotationStoresFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListAnnotationStoresFilter.ReadOnly =
    zio.aws.omics.model.ListAnnotationStoresFilter.wrap(buildAwsValue())
}
object ListAnnotationStoresFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListAnnotationStoresFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListAnnotationStoresFilter =
      zio.aws.omics.model.ListAnnotationStoresFilter(status.map(value => value))
    def status: Optional[zio.aws.omics.model.StoreStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.StoreStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationStoresFilter
  ) extends zio.aws.omics.model.ListAnnotationStoresFilter.ReadOnly {
    override val status: Optional[zio.aws.omics.model.StoreStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.StoreStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationStoresFilter
  ): zio.aws.omics.model.ListAnnotationStoresFilter.ReadOnly = new Wrapper(impl)
}
