package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAnnotationStoresResponse(
    annotationStores: Optional[
      Iterable[zio.aws.omics.model.AnnotationStoreItem]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse = {
    import ListAnnotationStoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse
      .builder()
      .optionallyWith(
        annotationStores.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.annotationStores)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListAnnotationStoresResponse.ReadOnly =
    zio.aws.omics.model.ListAnnotationStoresResponse.wrap(buildAwsValue())
}
object ListAnnotationStoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListAnnotationStoresResponse =
      zio.aws.omics.model.ListAnnotationStoresResponse(
        annotationStores.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def annotationStores
        : Optional[List[zio.aws.omics.model.AnnotationStoreItem.ReadOnly]]
    def nextToken: Optional[String]
    def getAnnotationStores: ZIO[Any, AwsError, List[
      zio.aws.omics.model.AnnotationStoreItem.ReadOnly
    ]] = AwsError.unwrapOptionField("annotationStores", annotationStores)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse
  ) extends zio.aws.omics.model.ListAnnotationStoresResponse.ReadOnly {
    override val annotationStores
        : Optional[List[zio.aws.omics.model.AnnotationStoreItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.annotationStores())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.AnnotationStoreItem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse
  ): zio.aws.omics.model.ListAnnotationStoresResponse.ReadOnly = new Wrapper(
    impl
  )
}
