package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  NextToken,
  ListMultipartReadSetUploadsRequestMaxResultsInteger,
  SequenceStoreId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMultipartReadSetUploadsRequest(
    sequenceStoreId: SequenceStoreId,
    maxResults: Optional[ListMultipartReadSetUploadsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest = {
    import ListMultipartReadSetUploadsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value =>
          ListMultipartReadSetUploadsRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.ListMultipartReadSetUploadsRequest.ReadOnly =
    zio.aws.omics.model.ListMultipartReadSetUploadsRequest.wrap(buildAwsValue())
}
object ListMultipartReadSetUploadsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListMultipartReadSetUploadsRequest =
      zio.aws.omics.model.ListMultipartReadSetUploadsRequest(
        sequenceStoreId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def sequenceStoreId: SequenceStoreId
    def maxResults
        : Optional[ListMultipartReadSetUploadsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      ListMultipartReadSetUploadsRequestMaxResultsInteger
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest
  ) extends zio.aws.omics.model.ListMultipartReadSetUploadsRequest.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val maxResults
        : Optional[ListMultipartReadSetUploadsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListMultipartReadSetUploadsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest
  ): zio.aws.omics.model.ListMultipartReadSetUploadsRequest.ReadOnly =
    new Wrapper(impl)
}
