package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListMultipartReadSetUploadsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    uploads: Optional[
      Iterable[zio.aws.omics.model.MultipartReadSetUploadListItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse = {
    import ListMultipartReadSetUploadsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        uploads.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.uploads)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.ListMultipartReadSetUploadsResponse.ReadOnly =
    zio.aws.omics.model.ListMultipartReadSetUploadsResponse
      .wrap(buildAwsValue())
}
object ListMultipartReadSetUploadsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListMultipartReadSetUploadsResponse =
      zio.aws.omics.model.ListMultipartReadSetUploadsResponse(
        nextToken.map(value => value),
        uploads.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def uploads: Optional[
      List[zio.aws.omics.model.MultipartReadSetUploadListItem.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getUploads: ZIO[Any, AwsError, List[
      zio.aws.omics.model.MultipartReadSetUploadListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("uploads", uploads)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse
  ) extends zio.aws.omics.model.ListMultipartReadSetUploadsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val uploads: Optional[
      List[zio.aws.omics.model.MultipartReadSetUploadListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.uploads())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.omics.model.MultipartReadSetUploadListItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse
  ): zio.aws.omics.model.ListMultipartReadSetUploadsResponse.ReadOnly =
    new Wrapper(impl)
}
