package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  NextToken,
  ListReadSetActivationJobsRequestMaxResultsInteger,
  SequenceStoreId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReadSetActivationJobsRequest(
    sequenceStoreId: SequenceStoreId,
    maxResults: Optional[ListReadSetActivationJobsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filter: Optional[zio.aws.omics.model.ActivateReadSetFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest = {
    import ListReadSetActivationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value =>
          ListReadSetActivationJobsRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.ListReadSetActivationJobsRequest.ReadOnly =
    zio.aws.omics.model.ListReadSetActivationJobsRequest.wrap(buildAwsValue())
}
object ListReadSetActivationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetActivationJobsRequest =
      zio.aws.omics.model.ListReadSetActivationJobsRequest(
        sequenceStoreId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        filter.map(value => value.asEditable)
      )
    def sequenceStoreId: SequenceStoreId
    def maxResults: Optional[ListReadSetActivationJobsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def filter: Optional[zio.aws.omics.model.ActivateReadSetFilter.ReadOnly]
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      ListReadSetActivationJobsRequestMaxResultsInteger
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.omics.model.ActivateReadSetFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest
  ) extends zio.aws.omics.model.ListReadSetActivationJobsRequest.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val maxResults
        : Optional[ListReadSetActivationJobsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListReadSetActivationJobsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val filter
        : Optional[zio.aws.omics.model.ActivateReadSetFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.ActivateReadSetFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest
  ): zio.aws.omics.model.ListReadSetActivationJobsRequest.ReadOnly =
    new Wrapper(impl)
}
