package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListReadSetActivationJobsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    activationJobs: Optional[
      Iterable[zio.aws.omics.model.ActivateReadSetJobItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse = {
    import ListReadSetActivationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        activationJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activationJobs)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.ListReadSetActivationJobsResponse.ReadOnly =
    zio.aws.omics.model.ListReadSetActivationJobsResponse.wrap(buildAwsValue())
}
object ListReadSetActivationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetActivationJobsResponse =
      zio.aws.omics.model.ListReadSetActivationJobsResponse(
        nextToken.map(value => value),
        activationJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def activationJobs
        : Optional[List[zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getActivationJobs: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly
    ]] = AwsError.unwrapOptionField("activationJobs", activationJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse
  ) extends zio.aws.omics.model.ListReadSetActivationJobsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val activationJobs
        : Optional[List[zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activationJobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.ActivateReadSetJobItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse
  ): zio.aws.omics.model.ListReadSetActivationJobsResponse.ReadOnly =
    new Wrapper(impl)
}
