package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  NextToken,
  ListReadSetExportJobsRequestMaxResultsInteger,
  SequenceStoreId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReadSetExportJobsRequest(
    sequenceStoreId: SequenceStoreId,
    maxResults: Optional[ListReadSetExportJobsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filter: Optional[zio.aws.omics.model.ExportReadSetFilter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest = {
    import ListReadSetExportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value =>
          ListReadSetExportJobsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ListReadSetExportJobsRequest.ReadOnly =
    zio.aws.omics.model.ListReadSetExportJobsRequest.wrap(buildAwsValue())
}
object ListReadSetExportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ListReadSetExportJobsRequest =
      zio.aws.omics.model.ListReadSetExportJobsRequest(
        sequenceStoreId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        filter.map(value => value.asEditable)
      )
    def sequenceStoreId: SequenceStoreId
    def maxResults: Optional[ListReadSetExportJobsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def filter: Optional[zio.aws.omics.model.ExportReadSetFilter.ReadOnly]
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getMaxResults
        : ZIO[Any, AwsError, ListReadSetExportJobsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.omics.model.ExportReadSetFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest
  ) extends zio.aws.omics.model.ListReadSetExportJobsRequest.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val maxResults
        : Optional[ListReadSetExportJobsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.omics.model.primitives
            .ListReadSetExportJobsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.omics.model.primitives.NextToken(value))
    override val filter
        : Optional[zio.aws.omics.model.ExportReadSetFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.omics.model.ExportReadSetFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest
  ): zio.aws.omics.model.ListReadSetExportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
